/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class InBlockLootCondition
implements LootCondition {
    private final Block block;

    public InBlockLootCondition(Block block) {
        this.block = block;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        return context.func_186493_a() != null && context.getWorld().func_180495_p(context.func_186493_a().func_180425_c()).func_177230_c() == this.block;
    }

    public static class Serialiser
    extends LootCondition.Serializer<InBlockLootCondition> {
        public Serialiser() {
            super(new ResourceLocation("midnight", "in_block"), InBlockLootCondition.class);
        }

        public void serialize(JsonObject json, InBlockLootCondition value, JsonSerializationContext context) {
            json.addProperty("block", value.block.getRegistryName().toString());
        }

        public InBlockLootCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            if (!json.has("block")) {
                throw new JsonSyntaxException("Missing block tag, expected to find a block registry name");
            }
            ResourceLocation rl = new ResourceLocation(json.get("block").getAsString());
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(rl);
            if (block == null) {
                throw new JsonSyntaxException("Invalid block tag. " + rl + " does not exist in the block registry.");
            }
            return new InBlockLootCondition(block);
        }
    }
}

