/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.registry;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegUtil {
    @Nonnull
    public static <T> T injected() {
        return null;
    }

    public static <T extends Block> T withName(T block, String name) {
        ResourceLocation registryName = GameData.checkPrefix((String)name);
        block.setRegistryName(registryName);
        block.func_149663_c(registryName.func_110624_b() + "." + registryName.func_110623_a());
        return block;
    }

    public static <T extends Item> T withName(T item, String name) {
        ResourceLocation registryName = GameData.checkPrefix((String)name);
        item.setRegistryName(registryName);
        item.func_77655_b(registryName.func_110624_b() + "." + registryName.func_110623_a());
        return item;
    }

    public static <T extends Potion> T withName(T potion, String name) {
        ResourceLocation registryName = GameData.checkPrefix((String)name);
        potion.setRegistryName(registryName);
        potion.func_76390_b(registryName.func_110624_b() + "." + registryName.func_110623_a());
        return potion;
    }

    public static <T extends IForgeRegistryEntry<T>> T withName(T entry, String name) {
        ResourceLocation registryName = GameData.checkPrefix((String)name);
        entry.setRegistryName(registryName);
        return entry;
    }

    public static <T extends Biome> T applyName(T biome) {
        String name = (String)ReflectionHelper.getPrivateValue(Biome.class, biome, (String[])new String[]{"biomeName", "field_76791_y"});
        ResourceLocation registryName = GameData.checkPrefix((String)name);
        biome.setRegistryName(registryName);
        return biome;
    }

    public static <T extends SoundEvent> T applyName(T sound) {
        ResourceLocation name = (ResourceLocation)ReflectionHelper.getPrivateValue(SoundEvent.class, sound, (String[])new String[]{"soundName", "field_187506_b"});
        sound.setRegistryName(name);
        ResourceLocation prefixedName = new ResourceLocation(name.func_110624_b(), "midnight." + name.func_110623_a());
        ReflectionHelper.setPrivateValue(SoundEvent.class, sound, (Object)prefixedName, (String[])new String[]{"soundName", "field_187506_b"});
        return sound;
    }
}

