/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world;

import com.mushroom.midnight.common.entity.RiftAttachment;
import com.mushroom.midnight.common.entity.RiftBridge;
import com.mushroom.midnight.common.network.MessageBridgeRemoval;
import com.mushroom.midnight.common.world.BridgeManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class BridgeManagerServer
extends WorldSavedData
implements BridgeManager {
    public static final String KEY = "midnight.bridge_manager";
    private final Int2ObjectMap<RiftBridge> bridges = new Int2ObjectOpenHashMap();
    private int currentId;

    public BridgeManagerServer(String key) {
        super(key);
    }

    public static BridgeManagerServer get(MinecraftServer server) {
        MapStorage storage = server.func_71218_a(0).func_175693_T();
        BridgeManagerServer data = (BridgeManagerServer)storage.func_75742_a(BridgeManagerServer.class, KEY);
        if (data == null) {
            data = new BridgeManagerServer(KEY);
            storage.func_75745_a(KEY, (WorldSavedData)data);
        }
        return data;
    }

    @Override
    public void update() {
        ObjectIterator iterator = this.bridges.values().iterator();
        while (iterator.hasNext()) {
            RiftBridge bridge = (RiftBridge)iterator.next();
            bridge.tickTimers();
            if (!bridge.tickState()) continue;
            bridge.exists = false;
            this.notifyRemoval(bridge);
            iterator.remove();
        }
    }

    @Override
    public RiftBridge createBridge(RiftAttachment attachment) {
        return new RiftBridge(this.currentId++, attachment);
    }

    @Override
    public void addBridge(RiftBridge bridge) {
        this.bridges.put(bridge.getId(), (Object)bridge);
        this.func_76185_a();
    }

    @Override
    public void removeBridge(int id) {
        RiftBridge bridge = (RiftBridge)this.bridges.remove(id);
        if (bridge != null) {
            this.notifyRemoval(bridge);
        }
    }

    private void notifyRemoval(RiftBridge bridge) {
        bridge.exists = false;
        bridge.getTracker().sendToTracking(new MessageBridgeRemoval(bridge.getId()));
        this.func_76185_a();
    }

    @Override
    @Nullable
    public RiftBridge getBridge(int id) {
        return (RiftBridge)this.bridges.get(id);
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74768_a("current_id", this.currentId);
        NBTTagList bridgeList = new NBTTagList();
        for (RiftBridge bridge : this.bridges.values()) {
            bridgeList.func_74742_a((NBTBase)bridge.serialize(new NBTTagCompound()));
        }
        compound.func_74782_a("bridges", (NBTBase)bridgeList);
        return compound;
    }

    public void func_76184_a(NBTTagCompound compound) {
        this.currentId = compound.func_74762_e("current_id");
        NBTTagList bridgeList = compound.func_150295_c("bridges", 10);
        for (int i = 0; i < bridgeList.func_74745_c(); ++i) {
            NBTTagCompound bridgeCompound = bridgeList.func_150305_b(i);
            RiftBridge bridge = RiftBridge.deserialize(bridgeCompound);
            this.bridges.put(bridge.getId(), (Object)bridge);
        }
    }
}

