/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world;

import com.mushroom.midnight.common.biome.config.SurfaceConfig;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.chunk.ChunkPrimer;

public class SurfaceCoverGenerator {
    private final int minSurfaceLayer;
    private final int maxSurfaceLayer;
    private int maxY = 255;

    public SurfaceCoverGenerator(int minSurfaceLayer, int maxSurfaceLayer) {
        this.minSurfaceLayer = minSurfaceLayer;
        this.maxSurfaceLayer = maxSurfaceLayer;
    }

    public SurfaceCoverGenerator withMaxY(int maxY) {
        this.maxY = maxY;
        return this;
    }

    public void coverSurface(SurfaceConfig config, ChunkPrimer primer, int x, int z, int depth) {
        IBlockState topBlock = config.getTopState();
        IBlockState fillerBlock = config.getFillerState();
        int currentDepth = -1;
        int localX = x & 0xF;
        int localZ = z & 0xF;
        boolean wet = false;
        int surfaceLayer = 0;
        for (int localY = this.maxY; localY >= 0; --localY) {
            IBlockState state = primer.func_177856_a(localX, localY, localZ);
            Material material = state.func_185904_a();
            if (material == Material.field_151586_h) {
                wet = true;
            } else if (material == Material.field_151579_a) {
                wet = false;
            }
            if (material != Material.field_151576_e) {
                currentDepth = -1;
                continue;
            }
            if (currentDepth >= depth) {
                wet = false;
                if (surfaceLayer++ <= this.maxSurfaceLayer) continue;
                break;
            }
            ++currentDepth;
            if (surfaceLayer < this.minSurfaceLayer || surfaceLayer > this.maxSurfaceLayer) continue;
            if (currentDepth == 0) {
                primer.func_177855_a(localX, localY, localZ, wet ? config.getWetState() : topBlock);
                continue;
            }
            primer.func_177855_a(localX, localY, localZ, wet ? config.getWetState() : fillerBlock);
        }
    }
}

