/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature;

import com.mushroom.midnight.common.registry.ModBlocks;
import com.mushroom.midnight.common.world.feature.MidnightNaturalFeature;
import java.util.HashSet;
import java.util.Set;
import java.util.function.IntFunction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;

public abstract class MidnightTreeFeature
extends MidnightNaturalFeature {
    protected final IBlockState log;
    protected final IBlockState leaves;

    protected MidnightTreeFeature(IBlockState log, IBlockState leaves) {
        this.log = log;
        if (leaves.func_177230_c() instanceof BlockLeaves) {
            leaves = leaves.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        }
        this.leaves = leaves;
    }

    protected boolean canFit(World world, BlockPos pos, int height, IntFunction<Integer> widthSupplier) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos);
        for (int localY = 0; localY < height; ++localY) {
            int width = widthSupplier.apply(localY);
            for (int localZ = -width; localZ <= width; ++localZ) {
                for (int localX = -width; localX <= width; ++localX) {
                    mutablePos.func_181079_c(pos.func_177958_n() + localX, pos.func_177956_o() + localY, pos.func_177952_p() + localZ);
                    if (this.canReplace(world, (BlockPos)mutablePos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean canGrow(World world, BlockPos pos) {
        BlockPos groundPos = pos.func_177977_b();
        IBlockState groundState = world.func_180495_p(groundPos);
        Block groundBlock = groundState.func_177230_c();
        return groundBlock.canSustainPlant(groundState, (IBlockAccess)world, groundPos, EnumFacing.UP, (IPlantable)ModBlocks.SHADOWROOT_SAPLING);
    }

    protected void notifyGrowth(World world, BlockPos pos) {
        BlockPos groundPos = pos.func_177977_b();
        IBlockState groundState = world.func_180495_p(groundPos);
        Block groundBlock = groundState.func_177230_c();
        groundBlock.onPlantGrow(groundState, world, groundPos, pos);
    }

    protected void placeLog(World world, BlockPos pos) {
        this.placeState(world, pos, this.log);
    }

    protected void placeLog(World world, BlockPos pos, BlockLog.EnumAxis axis) {
        this.placeState(world, pos, this.log.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)axis));
    }

    protected void placeLeaves(World world, BlockPos pos) {
        this.placeState(world, pos, this.leaves);
    }

    protected Set<BlockPos> produceBlob(BlockPos origin, double radius) {
        return this.produceBlob(origin, radius, radius);
    }

    protected Set<BlockPos> produceBlob(BlockPos origin, double horizontalRadius, double verticalRadius) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        int verticalRadiusCeil = MathHelper.func_76143_f((double)verticalRadius);
        int horizontalRadiusCeil = MathHelper.func_76143_f((double)horizontalRadius);
        BlockPos minPos = origin.func_177982_a(-horizontalRadiusCeil, -verticalRadiusCeil, -horizontalRadiusCeil);
        BlockPos maxPos = origin.func_177982_a(horizontalRadiusCeil, verticalRadiusCeil, horizontalRadiusCeil);
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)minPos, (BlockPos)maxPos)) {
            double deltaZ;
            double deltaY;
            double deltaX = (double)(pos.func_177958_n() - origin.func_177958_n()) / horizontalRadius;
            double distanceSquared = deltaX * deltaX + (deltaY = (double)(pos.func_177956_o() - origin.func_177956_o()) / verticalRadius) * deltaY + (deltaZ = (double)(pos.func_177952_p() - origin.func_177952_p()) / horizontalRadius) * deltaZ;
            if (!(distanceSquared <= 1.0)) continue;
            positions.add(pos.func_185334_h());
        }
        return positions;
    }

    @Override
    public DecorateBiomeEvent.Decorate.EventType getEventType() {
        return DecorateBiomeEvent.Decorate.EventType.TREE;
    }
}

