/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature.config;

import com.mushroom.midnight.common.registry.ModBlocks;
import com.mushroom.midnight.common.world.SurfacePlacementLevel;
import com.mushroom.midnight.common.world.feature.config.IPlacementConfig;
import com.mushroom.midnight.common.world.generator.WorldGenMoltenCrater;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DragonNestPlacementConfig
implements IPlacementConfig {
    private static final int CRATER_RANGE_CHUNKS = 3;
    private final int count;
    private final int scatterCount;

    public DragonNestPlacementConfig(int count, int scatterCount) {
        this.count = count;
        this.scatterCount = scatterCount;
    }

    @Override
    public void apply(World world, SurfacePlacementLevel placementLevel, Random random, BlockPos chunkOrigin, Consumer<BlockPos> generator) {
        if (!DragonNestPlacementConfig.isNearCrater(world, random, chunkOrigin)) {
            return;
        }
        for (int i = 0; i < this.count; ++i) {
            int offsetX = random.nextInt(16) + 8;
            int offsetZ = random.nextInt(16) + 8;
            BlockPos pos = chunkOrigin.func_177982_a(offsetX, 0, offsetZ);
            int surfaceY = placementLevel.getSurfacePos(world, pos).func_177956_o();
            int offsetY = surfaceY + random.nextInt(16);
            this.applyScatter(world, random, pos.func_177981_b(offsetY), generator);
        }
    }

    private void applyScatter(World world, Random random, BlockPos pos, Consumer<BlockPos> generator) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos);
        for (int i = 0; i < this.scatterCount; ++i) {
            int offsetX = random.nextInt(8) - random.nextInt(8);
            int offsetY = random.nextInt(8) - random.nextInt(8);
            int offsetZ = random.nextInt(8) - random.nextInt(8);
            mutablePos.func_181079_c(pos.func_177958_n() + offsetX, pos.func_177956_o() + offsetY, pos.func_177952_p() + offsetZ);
            IBlockState existingState = world.func_180495_p((BlockPos)mutablePos);
            if (!existingState.func_177230_c().isAir(existingState, (IBlockAccess)world, (BlockPos)mutablePos) || existingState.func_177230_c() == ModBlocks.MUSHROOM_INSIDE) continue;
            generator.accept(mutablePos.func_185334_h());
        }
    }

    private static boolean isNearCrater(World world, Random random, BlockPos chunkOrigin) {
        if (random.nextInt(10) != 0) {
            return false;
        }
        int chunkX = chunkOrigin.func_177958_n() >> 4;
        int chunkZ = chunkOrigin.func_177952_p() >> 4;
        for (int deltaZ = -3; deltaZ <= 3; ++deltaZ) {
            for (int deltaX = -3; deltaX <= 3; ++deltaX) {
                if (!WorldGenMoltenCrater.isCraterSource(world, chunkX + deltaX, chunkZ + deltaZ)) continue;
                return true;
            }
        }
        return false;
    }
}

