/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.template;

import com.mushroom.midnight.common.world.template.CompiledTemplate;
import com.mushroom.midnight.common.world.template.TemplateDataProcessor;
import com.mushroom.midnight.common.world.template.TemplatePostProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class TemplateCompiler {
    private final List<ResourceLocation> templates = new ArrayList<ResourceLocation>();
    private String anchorKey;
    private final Collection<BiConsumer<PlacementSettings, Random>> settingConfigurators = new ArrayList<BiConsumer<PlacementSettings, Random>>();
    private ITemplateProcessor processor;
    private TemplateDataProcessor dataProcessor;
    private final Collection<TemplatePostProcessor> postProcessors = new ArrayList<TemplatePostProcessor>();

    public static TemplateCompiler of(ResourceLocation ... templates) {
        return new TemplateCompiler().withTemplates(templates);
    }

    public TemplateCompiler withTemplates(ResourceLocation ... templates) {
        Collections.addAll(this.templates, templates);
        return this;
    }

    public TemplateCompiler withSettingConfigurator(BiConsumer<PlacementSettings, Random> configurator) {
        this.settingConfigurators.add(configurator);
        return this;
    }

    public TemplateCompiler withProcessor(ITemplateProcessor processor) {
        this.processor = processor;
        return this;
    }

    public TemplateCompiler withDataProcessor(TemplateDataProcessor processor) {
        this.dataProcessor = processor;
        return this;
    }

    public TemplateCompiler withPostProcessor(TemplatePostProcessor processor) {
        this.postProcessors.add(processor);
        return this;
    }

    public TemplateCompiler withAnchor(String key) {
        if (this.anchorKey != null) {
            throw new IllegalStateException("Template is already anchored to '" + this.anchorKey + "'");
        }
        this.anchorKey = key;
        return this;
    }

    public CompiledTemplate compile(World world, Random random, BlockPos origin) {
        ResourceLocation templateId = this.templates.get(random.nextInt(this.templates.size()));
        MinecraftServer server = world.func_73046_m();
        TemplateManager templateManager = world.func_72860_G().func_186340_h();
        PlacementSettings settings = this.buildPlacementSettings(random);
        Template template = templateManager.func_186237_a(server, templateId);
        BlockPos anchor = this.computeAnchor(template, settings);
        BlockPos anchoredOrigin = anchor != null ? origin.func_177973_b((Vec3i)anchor) : origin;
        return new CompiledTemplate(templateId, template, settings, anchoredOrigin, this.processor, this.dataProcessor, this.postProcessors);
    }

    @Nullable
    private BlockPos computeAnchor(Template template, PlacementSettings placementSettings) {
        if (this.anchorKey == null) {
            return null;
        }
        Map dataBlocks = template.func_186258_a(BlockPos.field_177992_a, placementSettings);
        return dataBlocks.entrySet().stream().filter(e -> ((String)e.getValue()).equals(this.anchorKey)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    private PlacementSettings buildPlacementSettings(Random random) {
        PlacementSettings settings = new PlacementSettings();
        for (BiConsumer<PlacementSettings, Random> configurator : this.settingConfigurators) {
            configurator.accept(settings, random);
        }
        return settings;
    }
}

