/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.client;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.FTBLibCommon;
import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.client.BuiltinChunkMap;
import com.feed_the_beast.ftblib.client.ClientConfig;
import com.feed_the_beast.ftblib.client.FTBLibClientConfig;
import com.feed_the_beast.ftblib.client.FTBLibClientConfigManager;
import com.feed_the_beast.ftblib.client.SidebarButtonManager;
import com.feed_the_beast.ftblib.command.client.CommandClientConfig;
import com.feed_the_beast.ftblib.command.client.CommandListAdvancements;
import com.feed_the_beast.ftblib.command.client.CommandPrintItem;
import com.feed_the_beast.ftblib.command.client.CommandPrintState;
import com.feed_the_beast.ftblib.command.client.CommandSimulateButton;
import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.client.ParticleColoredDust;
import com.feed_the_beast.ftblib.lib.gui.misc.ChunkSelectorMap;
import com.feed_the_beast.ftblib.lib.icon.PlayerHeadIcon;
import com.feed_the_beast.ftblib.lib.net.MessageToClient;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.lwjgl.opengl.Display;

public class FTBLibClient
extends FTBLibCommon {
    public static final Map<String, ClientConfig> CLIENT_CONFIG_MAP = new HashMap<String, ClientConfig>();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        FTBLibClientConfig.sync();
        ClientUtils.localPlayerHead = new PlayerHeadIcon(Minecraft.func_71410_x().func_110432_I().func_148256_e().getId());
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)FTBLibClientConfigManager.INSTANCE);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)SidebarButtonManager.INSTANCE);
        ChunkSelectorMap.setMap(new BuiltinChunkMap());
        if (System.getProperty("ftbdevenvironment", "0").equals("1")) {
            Display.setTitle((String)(Minecraft.func_71410_x().func_175600_c() + " Dev :: " + Minecraft.func_71410_x().func_110432_I().func_111285_a()));
        }
    }

    @Override
    public void postInit() {
        super.postInit();
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandClientConfig());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandSimulateButton());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandPrintItem());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandPrintState());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandListAdvancements());
    }

    @Override
    public void handleClientMessage(MessageToClient message) {
        if (FTBLibConfig.debugging.log_network) {
            FTBLib.LOGGER.info("Net RX: " + message.getClass().getName());
        }
        message.onMessage();
    }

    @Override
    public void spawnDust(World world, double x, double y, double z, float r, float g, float b, float a) {
        ClientUtils.spawnParticle((Particle)new ParticleColoredDust(world, x, y, z, r, g, b, a));
    }

    @Override
    public long getWorldTime() {
        return Minecraft.func_71410_x().field_71441_e == null ? super.getWorldTime() : Minecraft.func_71410_x().field_71441_e.func_82737_E();
    }
}

