/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.client.teamsgui;

import com.feed_the_beast.ftblib.client.teamsgui.GuiManagePlayersBase;
import com.feed_the_beast.ftblib.lib.EnumTeamStatus;
import com.feed_the_beast.ftblib.lib.data.FTBLibTeamGuiActions;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftblib.net.MessageMyTeamAction;
import com.feed_the_beast.ftblib.net.MessageMyTeamPlayerList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public class GuiManageMembers
extends GuiManagePlayersBase {
    public GuiManageMembers(Collection<MessageMyTeamPlayerList.Entry> m) {
        super(I18n.func_135052_a((String)"team_action.ftblib.members", (Object[])new Object[0]), m, (x$0, x$1) -> new ButtonPlayer((Panel)x$0, (MessageMyTeamPlayerList.Entry)x$1));
    }

    private static class ButtonPlayer
    extends GuiManagePlayersBase.ButtonPlayerBase {
        private ButtonPlayer(Panel panel, MessageMyTeamPlayerList.Entry m) {
            super(panel, m);
        }

        @Override
        Color4I getPlayerColor() {
            if (this.entry.requestingInvite) {
                return Color4I.getChatFormattingColor(TextFormatting.GOLD);
            }
            switch (this.entry.status) {
                case NONE: {
                    return this.getDefaultPlayerColor();
                }
                case MEMBER: 
                case MOD: {
                    return Color4I.getChatFormattingColor(TextFormatting.DARK_GREEN);
                }
                case INVITED: {
                    return Color4I.getChatFormattingColor(TextFormatting.BLUE);
                }
                case ALLY: {
                    return Color4I.getChatFormattingColor(TextFormatting.DARK_AQUA);
                }
            }
            return this.getDefaultPlayerColor();
        }

        @Override
        public void addMouseOverText(List<String> list) {
            if (!this.entry.status.isNone()) {
                list.add(I18n.func_135052_a((String)this.entry.status.getLangKey(), (Object[])new Object[0]));
            } else if (this.entry.requestingInvite) {
                list.add(I18n.func_135052_a((String)"ftblib.lang.team_status.requesting_invite", (Object[])new Object[0]));
            }
            if (this.entry.requestingInvite) {
                list.add(I18n.func_135052_a((String)"ftblib.lang.team.gui.members.requesting_invite", (Object[])new Object[0]));
            } else if (this.entry.status.isEqualOrGreaterThan(EnumTeamStatus.MEMBER)) {
                list.add(I18n.func_135052_a((String)"ftblib.lang.team.gui.members.kick", (Object[])new Object[0]));
            } else if (this.entry.status == EnumTeamStatus.INVITED) {
                list.add(I18n.func_135052_a((String)"ftblib.lang.team.gui.members.cancel_invite", (Object[])new Object[0]));
            }
            if (this.entry.status == EnumTeamStatus.NONE || this.entry.requestingInvite) {
                list.add(I18n.func_135052_a((String)"ftblib.lang.team.gui.members.invite", (Object[])new Object[0]));
            }
            if (this.entry.requestingInvite) {
                list.add(I18n.func_135052_a((String)"ftblib.lang.team.gui.members.deny_request", (Object[])new Object[0]));
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("player", this.entry.name);
            if (this.entry.requestingInvite) {
                if (button.isLeft()) {
                    data.func_74778_a("action", "invite");
                    this.entry.status = EnumTeamStatus.MEMBER;
                } else {
                    data.func_74778_a("action", "deny_request");
                    this.entry.status = EnumTeamStatus.NONE;
                }
                this.entry.requestingInvite = false;
            } else if (this.entry.status == EnumTeamStatus.NONE) {
                if (button.isLeft()) {
                    data.func_74778_a("action", "invite");
                    this.entry.status = EnumTeamStatus.INVITED;
                }
            } else if (this.entry.status.isEqualOrGreaterThan(EnumTeamStatus.MEMBER)) {
                if (!button.isLeft()) {
                    data.func_74778_a("action", "kick");
                    this.entry.requestingInvite = true;
                    this.entry.status = EnumTeamStatus.NONE;
                }
            } else if (this.entry.status == EnumTeamStatus.INVITED && !button.isLeft()) {
                data.func_74778_a("action", "cancel_invite");
                this.entry.status = EnumTeamStatus.NONE;
            }
            if (data.func_74764_b("action")) {
                new MessageMyTeamAction(FTBLibTeamGuiActions.MEMBERS.getId(), data).sendToServer();
            }
            this.updateIcon();
        }
    }
}

