/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiSelectTeamValue;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.FinalIDObject;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.ITextComponent;

public class ConfigTeamClient
extends ConfigString {
    public final Map<String, TeamInst> map = new HashMap<String, TeamInst>();

    public ConfigTeamClient(String v) {
        super(v, ForgeTeam.TEAM_ID_PATTERN);
    }

    @Override
    public String getId() {
        return "team";
    }

    @Override
    public ITextComponent getStringForGUI() {
        TeamInst inst = this.map.get(this.getString());
        if (inst != null) {
            return inst.title.func_150259_f();
        }
        return super.getStringForGUI();
    }

    @Override
    public ConfigTeamClient copy() {
        ConfigTeamClient config = new ConfigTeamClient(this.getString());
        for (TeamInst inst : this.map.values()) {
            TeamInst inst1 = new TeamInst(inst.uid, inst.getId());
            inst1.title = inst.title.func_150259_f();
            inst1.icon = inst.icon.copy();
            config.map.put(inst1.getId(), inst1);
        }
        return config;
    }

    @Override
    public Color4I getColor() {
        return Color4I.LIGHT_GREEN;
    }

    @Override
    public void addInfo(ConfigValueInstance inst, List<String> list) {
    }

    @Override
    public List<String> getVariants() {
        return new ArrayList<String>(this.map.keySet());
    }

    @Override
    public void onClicked(IOpenableGui gui, ConfigValueInstance inst, MouseButton button, Runnable callback) {
        if (inst.getCanEdit()) {
            new GuiSelectTeamValue(this, gui, callback).openGui();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        nbt.func_74778_a(key, this.getString());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        NBTBase id = nbt.func_74781_a(key);
        if (id instanceof NBTTagString) {
            this.setString(((NBTTagString)id).func_150285_a_());
        } else if (id instanceof NBTPrimitive) {
            Object team = null;
            short ids = ((NBTPrimitive)id).func_150289_e();
            for (TeamInst inst : this.map.values()) {
                if (inst.uid != ids) continue;
                this.setString(inst.getId());
                return;
            }
        }
    }

    @Override
    public void writeData(DataOut data) {
        throw new IllegalStateException("Can't write Team client property!");
    }

    @Override
    public void readData(DataIn data) {
        int s = data.readVarInt();
        this.map.clear();
        for (int i = 0; i < s; ++i) {
            short uid = data.readShort();
            String id = data.readString();
            TeamInst inst = new TeamInst(uid, id);
            inst.title = data.readTextComponent();
            inst.icon = data.readIcon();
            this.map.put(inst.getId(), inst);
        }
        this.setString(data.readString());
    }

    public static class TeamInst
    extends FinalIDObject {
        public final short uid;
        public ITextComponent title;
        public Icon icon;

        public TeamInst(short u, String id) {
            super(id);
            this.uid = u;
        }
    }
}

