/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.net;

import com.feed_the_beast.ftblib.FTBLibCommon;
import com.feed_the_beast.ftblib.lib.data.Action;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiActionList;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToClient;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftblib.net.FTBLibNetHandler;
import com.feed_the_beast.ftblib.net.MessageMyTeamAction;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageMyTeamGuiResponse
extends MessageToClient {
    private ITextComponent title;
    private Collection<Action.Inst> actions;

    public MessageMyTeamGuiResponse() {
    }

    public MessageMyTeamGuiResponse(ForgePlayer player) {
        this.title = player.team.getTitle();
        this.actions = new ArrayList<Action.Inst>();
        NBTTagCompound emptyData = new NBTTagCompound();
        for (Action action : FTBLibCommon.TEAM_GUI_ACTIONS.values()) {
            Action.Type type = action.getType(player, emptyData);
            if (!type.isVisible()) continue;
            this.actions.add(new Action.Inst(action, type));
        }
    }

    @Override
    public NetworkWrapper getWrapper() {
        return FTBLibNetHandler.MY_TEAM;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeTextComponent(this.title);
        data.writeCollection(this.actions, Action.Inst.SERIALIZER);
    }

    @Override
    public void readData(DataIn data) {
        this.title = data.readTextComponent();
        this.actions = data.readCollection(Action.Inst.DESERIALIZER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        new GuiActionList(this.title.func_150254_d(), this.actions, id -> new MessageMyTeamAction((ResourceLocation)id, new NBTTagCompound()).sendToServer()).openGui();
    }
}

