/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.network.messages;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import omtteam.omlib.api.permission.EnumAccessLevel;
import omtteam.omlib.api.permission.GlobalTrustRegister;
import omtteam.omlib.api.permission.IHasOwner;
import omtteam.omlib.api.tile.IHasTrustManager;
import omtteam.omlib.network.ISyncable;
import omtteam.omlib.util.player.Player;
import omtteam.omlib.util.player.PlayerUtil;

public class MessageModifyPermissions
implements IMessage {
    private int x;
    private int y;
    private int z;
    private int change;
    private String player;
    private boolean hasTile;
    private boolean isGlobal;
    private Player owner;

    public MessageModifyPermissions() {
    }

    public MessageModifyPermissions(String player, @Nullable TileEntity te, boolean isGlobal, Player owner, int change) {
        if (te != null) {
            this.x = te.func_174877_v().func_177958_n();
            this.y = te.func_174877_v().func_177956_o();
            this.z = te.func_174877_v().func_177952_p();
            this.hasTile = true;
        }
        this.player = player;
        this.isGlobal = isGlobal;
        this.owner = owner;
        this.change = change;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.player = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.owner = Player.readFromByteBuf(buf);
        this.hasTile = buf.readBoolean();
        this.isGlobal = buf.readBoolean();
        this.change = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.player);
        Player.writeToByteBuf(this.owner, buf);
        buf.writeBoolean(this.hasTile);
        buf.writeBoolean(this.isGlobal);
        buf.writeInt(this.change);
    }

    public static class MessageHandlerModifyPermissions
    implements IMessageHandler<MessageModifyPermissions, IMessage> {
        public IMessage onMessage(MessageModifyPermissions messageIn, MessageContext ctxIn) {
            MessageModifyPermissions message = messageIn;
            MessageContext ctx = ctxIn;
            ((WorldServer)ctx.getServerHandler().field_147369_b.func_130014_f_()).func_152344_a(() -> {
                World world = ctx.getServerHandler().field_147369_b.func_130014_f_();
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (message.hasTile) {
                    TileEntity entity = world.func_175625_s(new BlockPos(message.x, message.y, message.z));
                    IHasTrustManager machine = null;
                    if (entity instanceof IHasTrustManager) {
                        machine = (IHasTrustManager)entity;
                    }
                    if (machine != null && PlayerUtil.isPlayerAdmin((EntityPlayer)player, (IHasOwner)machine)) {
                        machine.getTrustManager().changePermission(message.player, message.change);
                        if (machine instanceof ISyncable) {
                            ((ISyncable)((Object)machine)).sendMessageToAllTracking();
                        }
                    }
                } else if (message.isGlobal) {
                    GlobalTrustRegister.instance.changePermission(message.owner, message.player, EnumAccessLevel.NONE);
                }
            });
            return null;
        }
    }
}

