/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.tileentity;

import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import omtteam.omlib.compatibility.OMLibModCompatibility;
import omtteam.omlib.handler.OMConfig;
import omtteam.omlib.power.OMEnergyStorage;
import omtteam.omlib.power.ic2.BaseOMEUReceiverWrapper;
import omtteam.omlib.power.ic2.EUCapabilities;
import omtteam.omlib.power.rf.BaseRFReceiverWrapper;
import omtteam.omlib.power.rf.RFCapabilities;
import omtteam.omlib.power.tesla.BaseOMTeslaReceiverWrapper;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyReceiver", modid="redstoneflux")})
@MethodsReturnNonnullByDefault
public abstract class TileEntityElectric
extends TileEntityOwnedBlock {
    protected OMEnergyStorage storage;
    protected Object teslaContainer;
    protected Object euContainer;
    protected Object rfContainer;
    protected boolean wasAddedToEnergyNet = false;

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("maxStorage", this.storage.getMaxEnergyStored());
        nbtTagCompound.func_74768_a("energyStored", this.storage.getEnergyStored());
        nbtTagCompound.func_74768_a("maxIO", this.storage.getMaxReceive());
        return nbtTagCompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.storage.setCapacity(nbtTagCompound.func_74762_e("maxStorage"));
        this.storage.setEnergyStored(nbtTagCompound.func_74762_e("energyStored"));
        this.storage.setMaxReceive(nbtTagCompound.func_74762_e("maxIO"));
    }

    public void onLoad() {
        if (OMLibModCompatibility.IC2Loaded && OMConfig.GENERAL.EUSupport && !this.wasAddedToEnergyNet && !this.func_145831_w().field_72995_K) {
            this.addToIc2EnergyNetwork();
            this.wasAddedToEnergyNet = true;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onChunkUnload();
    }

    public void onChunkUnload() {
        if (this.wasAddedToEnergyNet && OMLibModCompatibility.IC2Loaded) {
            this.removeFromIc2EnergyNetwork();
            this.wasAddedToEnergyNet = false;
        }
    }

    public int getEnergyStored(@Nullable EnumFacing facing) {
        OMEnergyStorage storage = (OMEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, facing);
        if (storage != null) {
            return storage.getEnergyStored();
        }
        return 0;
    }

    public int getMaxEnergyStored(@Nullable EnumFacing facing) {
        OMEnergyStorage storage = (OMEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, facing);
        if (storage != null) {
            return storage.getMaxEnergyStored();
        }
        return 0;
    }

    public void setCapacity(int maxStorage, @Nullable EnumFacing facing) {
        OMEnergyStorage storage = (OMEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, facing);
        if (storage != null) {
            storage.setCapacity(maxStorage);
        }
    }

    public void setEnergyStored(int energy, @Nullable EnumFacing facing) {
        OMEnergyStorage storage = (OMEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, facing);
        if (storage != null) {
            storage.setEnergyStored(energy);
        }
    }

    public int extractEnergy(int energy, @Nullable EnumFacing facing) {
        OMEnergyStorage storage = (OMEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, facing);
        if (storage != null) {
            return storage.extractEnergy(energy, false);
        }
        return 0;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (OMLibModCompatibility.TeslaLoaded && this.hasTeslaCapability(capability, facing) && this.getTeslaCapability(capability, facing) != null) {
            return this.getTeslaCapability(capability, facing);
        }
        if (OMLibModCompatibility.IC2Loaded && this.hasEUCapability(capability, facing) && this.getEUCapability(capability, facing) != null) {
            return this.getEUCapability(capability, facing);
        }
        if (OMLibModCompatibility.CoFHApiLoaded && this.hasRFCapability(capability, facing) && this.getRFCapability(capability, facing) != null) {
            return this.getRFCapability(capability, facing);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.storage;
        }
        return (T)super.getCapability(capability, facing);
    }

    @ParametersAreNonnullByDefault
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (OMLibModCompatibility.TeslaLoaded && this.hasTeslaCapability(capability, facing)) {
            return true;
        }
        if (OMLibModCompatibility.IC2Loaded && this.hasEUCapability(capability, facing)) {
            return true;
        }
        if (OMLibModCompatibility.CoFHApiLoaded && this.hasRFCapability(capability, facing)) {
            return true;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Optional.Method(modid="redstoneflux")
    private boolean hasRFCapability(Capability<?> capability, EnumFacing facing) {
        return capability == RFCapabilities.CAPABILITY_CONSUMER;
    }

    @Optional.Method(modid="redstoneflux")
    @Nullable
    private <T> T getRFCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == TeslaCapabilities.CAPABILITY_CONSUMER) {
            return (T)this.getRFContainer();
        }
        return null;
    }

    @Optional.Method(modid="redstoneflux")
    private BaseRFReceiverWrapper getRFContainer() {
        if (this.rfContainer instanceof BaseRFReceiverWrapper) {
            return (BaseRFReceiverWrapper)this.rfContainer;
        }
        this.rfContainer = new BaseRFReceiverWrapper(this, EnumFacing.DOWN);
        return (BaseRFReceiverWrapper)this.rfContainer;
    }

    @Optional.Method(modid="tesla")
    private BaseOMTeslaReceiverWrapper getTeslaContainer() {
        if (this.teslaContainer instanceof BaseOMTeslaReceiverWrapper) {
            return (BaseOMTeslaReceiverWrapper)this.teslaContainer;
        }
        this.teslaContainer = new BaseOMTeslaReceiverWrapper(this, EnumFacing.DOWN);
        return (BaseOMTeslaReceiverWrapper)this.teslaContainer;
    }

    @Optional.Method(modid="ic2")
    private BaseOMEUReceiverWrapper getEUContainer() {
        if (this.euContainer instanceof BaseOMEUReceiverWrapper) {
            return (BaseOMEUReceiverWrapper)this.euContainer;
        }
        this.euContainer = new BaseOMEUReceiverWrapper(this, EnumFacing.DOWN);
        return (BaseOMEUReceiverWrapper)this.euContainer;
    }

    @Optional.Method(modid="tesla")
    private boolean hasTeslaCapability(Capability<?> capability, EnumFacing facing) {
        return capability == TeslaCapabilities.CAPABILITY_CONSUMER;
    }

    @Optional.Method(modid="tesla")
    @Nullable
    private <T> T getTeslaCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == TeslaCapabilities.CAPABILITY_CONSUMER) {
            return (T)this.getTeslaContainer();
        }
        return null;
    }

    @Optional.Method(modid="ic2")
    private boolean hasEUCapability(Capability<?> capability, EnumFacing facing) {
        return capability == EUCapabilities.CAPABILITY_CONSUMER;
    }

    @Optional.Method(modid="ic2")
    @Nullable
    private <T> T getEUCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EUCapabilities.CAPABILITY_CONSUMER) {
            return (T)this.getEUContainer();
        }
        return null;
    }

    @Optional.Method(modid="ic2")
    protected void addToIc2EnergyNetwork() {
        if (!this.field_145850_b.field_72995_K) {
            EnergyTileLoadEvent event = new EnergyTileLoadEvent((IEnergyTile)this.getEUContainer());
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    @Optional.Method(modid="ic2")
    private void removeFromIc2EnergyNetwork() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this.getEUContainer()));
    }
}

