/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.block;

import electroblob.wizardry.tileentity.TileEntityStatue;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStatue
extends Block
implements ITileEntityProvider {
    private boolean isIce;
    public static final String PETRIFIED_NBT_KEY = "petrified";
    public static final String FROZEN_NBT_KEY = "frozen";

    public BlockStatue(Material material) {
        super(material);
        boolean bl = this.isIce = material == Material.field_151588_w;
        if (this.isIce) {
            this.setDefaultSlipperiness(0.98f);
            this.func_149672_a(SoundType.field_185853_f);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!this.isIce && world.func_175625_s(pos) instanceof TileEntityStatue) {
            TileEntityStatue statue = (TileEntityStatue)world.func_175625_s(pos);
            if (statue.creature != null) {
                return new AxisAlignedBB((double)((float)Math.max(0.5 - (double)(statue.creature.field_70130_N / 2.0f), 0.0)), 0.0, (double)((float)Math.max(0.5 - (double)(statue.creature.field_70130_N / 2.0f), 0.0)), (double)((float)Math.min(0.5 + (double)(statue.creature.field_70130_N / 2.0f), 1.0)), statue.position == statue.parts ? (double)Math.min(statue.creature.field_70131_O - (float)statue.parts + 1.0f, 1.0f) : 1.0, (double)((float)Math.min(0.5 + (double)(statue.creature.field_70130_N / 2.0f), 1.0)));
            }
        }
        return field_185505_j;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return this.isIce ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.SOLID;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return this.isIce ? EnumBlockRenderType.MODEL : EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityStatue(this.isIce);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            TileEntityStatue tileentity = (TileEntityStatue)world.func_175625_s(pos);
            if (tileentity != null) {
                if (tileentity.parts == 2) {
                    if (tileentity.position == 2) {
                        world.func_175655_b(pos.func_177977_b(), false);
                    } else {
                        world.func_175655_b(pos.func_177984_a(), false);
                    }
                } else if (tileentity.parts == 3) {
                    if (tileentity.position == 3) {
                        world.func_175655_b(pos.func_177977_b(), false);
                        world.func_175655_b(pos.func_177979_c(2), false);
                    } else if (tileentity.position == 2) {
                        world.func_175655_b(pos.func_177977_b(), false);
                        world.func_175655_b(pos.func_177984_a(), false);
                    } else {
                        world.func_175655_b(pos.func_177984_a(), false);
                        world.func_175655_b(pos.func_177981_b(2), false);
                    }
                }
            }
            if (tileentity != null && tileentity.position == 1 && tileentity.creature != null) {
                tileentity.creature.getEntityData().func_82580_o(PETRIFIED_NBT_KEY);
                tileentity.creature.field_70128_L = false;
                world.func_72838_d((Entity)tileentity.creature);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        return this.isIce && block == this ? false : super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public boolean convertToStatue(EntityLiving entity, int duration) {
        if (entity.field_70725_aQ > 0) {
            return false;
        }
        BlockPos pos = new BlockPos((Entity)entity);
        World world = entity.field_70170_p;
        entity.field_70737_aN = 0;
        entity.func_70066_B();
        if (((double)entity.field_70131_O < 1.2 || entity.func_70631_g_()) && WizardryUtilities.canBlockBeReplaced(world, pos)) {
            world.func_175656_a(pos, this.func_176223_P());
            if (world.func_175625_s(pos) instanceof TileEntityStatue) {
                ((TileEntityStatue)world.func_175625_s(pos)).setCreatureAndPart(entity, 1, 1);
                ((TileEntityStatue)world.func_175625_s(pos)).setLifetime(duration);
            }
            entity.getEntityData().func_74757_a(this.isIce ? FROZEN_NBT_KEY : PETRIFIED_NBT_KEY, true);
            entity.func_70106_y();
            return true;
        }
        if ((double)entity.field_70131_O < 2.5 && WizardryUtilities.canBlockBeReplaced(world, pos) && WizardryUtilities.canBlockBeReplaced(world, pos.func_177984_a())) {
            world.func_175656_a(pos, this.func_176223_P());
            if (world.func_175625_s(pos) instanceof TileEntityStatue) {
                ((TileEntityStatue)world.func_175625_s(pos)).setCreatureAndPart(entity, 1, 2);
                ((TileEntityStatue)world.func_175625_s(pos)).setLifetime(duration);
            }
            world.func_175656_a(pos.func_177984_a(), this.func_176223_P());
            if (world.func_175625_s(pos.func_177984_a()) instanceof TileEntityStatue) {
                ((TileEntityStatue)world.func_175625_s(pos.func_177984_a())).setCreatureAndPart(entity, 2, 2);
            }
            entity.getEntityData().func_74757_a(this.isIce ? FROZEN_NBT_KEY : PETRIFIED_NBT_KEY, true);
            entity.func_70106_y();
            return true;
        }
        if (WizardryUtilities.canBlockBeReplaced(world, pos) && WizardryUtilities.canBlockBeReplaced(world, pos.func_177984_a()) && WizardryUtilities.canBlockBeReplaced(world, pos.func_177981_b(2))) {
            world.func_175656_a(pos, this.func_176223_P());
            if (world.func_175625_s(pos) instanceof TileEntityStatue) {
                ((TileEntityStatue)world.func_175625_s(pos)).setCreatureAndPart(entity, 1, 3);
                ((TileEntityStatue)world.func_175625_s(pos)).setLifetime(duration);
            }
            world.func_175656_a(pos.func_177984_a(), this.func_176223_P());
            if (world.func_175625_s(pos.func_177984_a()) instanceof TileEntityStatue) {
                ((TileEntityStatue)world.func_175625_s(pos.func_177984_a())).setCreatureAndPart(entity, 2, 3);
            }
            world.func_175656_a(pos.func_177981_b(2), this.func_176223_P());
            if (world.func_175625_s(pos.func_177981_b(2)) instanceof TileEntityStatue) {
                ((TileEntityStatue)world.func_175625_s(pos.func_177981_b(2))).setCreatureAndPart(entity, 3, 3);
            }
            entity.getEntityData().func_74757_a(this.isIce ? FROZEN_NBT_KEY : PETRIFIED_NBT_KEY, true);
            entity.func_70106_y();
            return true;
        }
        return false;
    }
}

