/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.command;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.data.SpellEmitterData;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.SpellModifiers;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class SpellEmitter
implements ITickable {
    protected final Spell spell;
    protected World world;
    protected final double x;
    protected final double y;
    protected final double z;
    protected final EnumFacing direction;
    protected final int duration;
    protected final SpellModifiers modifiers;
    protected int castingTick = 0;
    protected boolean needsRemoving = false;

    protected SpellEmitter(Spell spell, World world, double x, double y, double z, EnumFacing direction, int duration, SpellModifiers modifiers) {
        this.spell = spell;
        this.world = world;
        this.duration = duration;
        this.x = x;
        this.y = y;
        this.z = z;
        this.direction = direction;
        this.modifiers = modifiers;
    }

    protected void markForRemoval() {
        this.needsRemoving = true;
    }

    public boolean needsRemoving() {
        return this.needsRemoving;
    }

    protected SpellCastEvent.Source getSource() {
        return SpellCastEvent.Source.COMMAND;
    }

    public void setWorld(World world) {
        if (world.field_72995_K && this.world == null) {
            this.world = world;
        } else {
            Wizardry.logger.warn("Tried to change the world for a spell emitter, this shouldn't happen!");
        }
    }

    public void func_73660_a() {
        if (this.castingTick < this.duration && !MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Tick(this.getSource(), this.spell, this.world, this.x, this.y, this.z, this.direction, this.modifiers, this.castingTick)) && this.spell.cast(this.world, this.x, this.y, this.z, this.direction, this.castingTick, this.duration, this.modifiers)) {
            if (this.castingTick == 0) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(this.getSource(), this.spell, this.world, this.x, this.y, this.z, this.direction, this.modifiers));
            }
            ++this.castingTick;
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Finish(this.getSource(), this.spell, this.world, this.x, this.y, this.z, this.direction, this.modifiers, this.castingTick));
        this.spell.finishCasting(this.world, null, this.x, this.y, this.z, this.direction, this.duration, this.modifiers);
        this.markForRemoval();
    }

    public void write(ByteBuf buf) {
        buf.writeInt(this.spell.networkID());
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeInt(this.direction.func_176745_a());
        buf.writeInt(this.duration - this.castingTick);
        this.modifiers.write(buf);
    }

    public static SpellEmitter read(ByteBuf buf) {
        Spell spell = Spell.byNetworkID(buf.readInt());
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        EnumFacing direction = EnumFacing.func_82600_a((int)buf.readInt());
        int duration = buf.readInt();
        SpellModifiers modifiers = new SpellModifiers();
        modifiers.read(buf);
        return new SpellEmitter(spell, null, x, y, z, direction, duration, modifiers);
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("spell", this.spell.metadata());
        nbt.func_74780_a("x", this.x);
        nbt.func_74780_a("y", this.y);
        nbt.func_74780_a("z", this.z);
        nbt.func_74768_a("direction", this.direction.func_176745_a());
        nbt.func_74768_a("duration", this.duration);
        NBTExtras.storeTagSafely(nbt, "modifiers", (NBTBase)this.modifiers.toNBT());
        nbt.func_74768_a("castingTick", this.castingTick);
        return nbt;
    }

    public static SpellEmitter fromNBT(World world, NBTTagCompound nbt) {
        Spell spell = Spell.byMetadata(nbt.func_74762_e("spell"));
        double x = nbt.func_74769_h("x");
        double y = nbt.func_74769_h("y");
        double z = nbt.func_74769_h("z");
        EnumFacing direction = EnumFacing.func_82600_a((int)nbt.func_74762_e("direction"));
        int duration = nbt.func_74762_e("duration");
        SpellModifiers modifiers = SpellModifiers.fromNBT(nbt.func_74775_l("modifiers"));
        int castingTick = nbt.func_74762_e("castingTick");
        SpellEmitter emitter = new SpellEmitter(spell, world, x, y, z, direction, duration, modifiers);
        emitter.castingTick = castingTick;
        return emitter;
    }

    public static void add(Spell spell, World world, double x, double y, double z, EnumFacing direction, int duration, SpellModifiers modifiers) {
        if (spell.isContinuous) {
            if (duration <= 0) {
                Wizardry.logger.warn("Adding a spell emitter with negative or zero duration!");
            }
            SpellEmitterData.get(world).add(new SpellEmitter(spell, world, x, y, z, direction, duration, modifiers));
        } else {
            Wizardry.logger.warn("Tried to add a non-continuous spell emitter for spell {}", (Object)spell.getRegistryName());
        }
    }
}

