/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.data;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.command.SpellEmitter;
import electroblob.wizardry.packet.PacketEmitterData;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.util.NBTExtras;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class SpellEmitterData
extends WorldSavedData {
    public static final String NAME = "ebwizardry_spell_emitters";
    private final List<SpellEmitter> emitters = new ArrayList<SpellEmitter>();
    private NBTTagList emitterTags = null;

    public SpellEmitterData() {
        this(NAME);
    }

    public SpellEmitterData(String name) {
        super(name);
    }

    public static SpellEmitterData get(World world) {
        SpellEmitterData instance = (SpellEmitterData)world.getPerWorldStorage().func_75742_a(SpellEmitterData.class, NAME);
        if (instance == null) {
            instance = new SpellEmitterData();
            world.getPerWorldStorage().func_75745_a(NAME, (WorldSavedData)instance);
        } else if (instance.emitters.isEmpty() && instance.emitterTags != null) {
            instance.loadEmitters(world);
        }
        return instance;
    }

    public void sync(EntityPlayerMP player) {
        PacketEmitterData.Message msg = new PacketEmitterData.Message(this.emitters);
        WizardryPacketHandler.net.sendTo((IMessage)msg, player);
        Wizardry.logger.info("Synchronising spell emitters for " + player.func_70005_c_());
    }

    public void add(SpellEmitter emitter) {
        this.emitters.add(emitter);
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.emitterTags = nbt.func_150295_c("emitters", 10);
    }

    private void loadEmitters(World world) {
        this.emitters.clear();
        this.emitters.addAll(NBTExtras.NBTToList(this.emitterTags, t -> SpellEmitter.fromNBT(world, t)));
        this.emitterTags = null;
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTExtras.storeTagSafely(compound, "emitters", (NBTBase)NBTExtras.listToNBT(this.emitters, SpellEmitter::toNBT));
        return compound;
    }

    public static void update(World world) {
        SpellEmitterData data = SpellEmitterData.get(world);
        if (!data.emitters.isEmpty()) {
            data.emitters.forEach(SpellEmitter::func_73660_a);
            data.emitters.removeIf(SpellEmitter::needsRemoving);
            data.func_76185_a();
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && event.phase == TickEvent.Phase.END) {
            SpellEmitterData.update(event.world);
        }
    }

    @SubscribeEvent
    public static void onWorldLoadEvent(WorldEvent.Load event) {
        SpellEmitterData.get(event.getWorld());
    }

    @SubscribeEvent
    public static void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            SpellEmitterData.get(event.player.field_70170_p).sync((EntityPlayerMP)event.player);
        }
    }
}

