/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.projectile;

import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.RayTracer;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public abstract class EntityMagicProjectile
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    public static final double LAUNCH_Y_OFFSET = 0.1;
    public static final int SEEKING_TIME = 15;
    public float damageMultiplier = 1.0f;

    public EntityMagicProjectile(World world) {
        super(world);
    }

    public void aim(EntityLivingBase caster, float speed) {
        this.func_70107_b(caster.field_70165_t, caster.func_174813_aQ().field_72338_b + (double)caster.func_70047_e() - 0.1, caster.field_70161_v);
        this.func_184538_a((Entity)caster, caster.field_70125_A, caster.field_70177_z, 0.0f, speed, 1.0f);
        this.field_70192_c = caster;
        this.field_184539_c = caster;
    }

    public void aim(EntityLivingBase caster, Entity target, float speed, float aimingError) {
        this.field_70192_c = caster;
        this.field_184539_c = this.field_70192_c;
        this.field_70163_u = caster.func_174813_aQ().field_72338_b + (double)caster.func_70047_e() - 0.1;
        double dx = target.field_70165_t - caster.field_70165_t;
        double dy = !this.func_189652_ae() ? target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - this.field_70163_u : target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - this.field_70163_u;
        double dz = target.field_70161_v - caster.field_70161_v;
        double horizontalDistance = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        if (horizontalDistance >= 1.0E-7) {
            double dxNormalised = dx / horizontalDistance;
            double dzNormalised = dz / horizontalDistance;
            this.func_70107_b(caster.field_70165_t + dxNormalised, this.field_70163_u, caster.field_70161_v + dzNormalised);
            float bulletDropCompensation = !this.func_189652_ae() ? (float)horizontalDistance * 0.2f : 0.0f;
            this.func_70186_c(dx, dy + (double)bulletDropCompensation, dz, speed, aimingError);
        }
    }

    public void setCaster(EntityLivingBase caster) {
        this.field_70192_c = caster;
        this.field_184539_c = caster;
    }

    public float getSeekingStrength() {
        return this.func_85052_h() instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)this.func_85052_h(), WizardryItems.ring_seeking) ? 2.0f : 0.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getLifetime() >= 0 && this.field_70173_aa > this.getLifetime()) {
            this.func_70106_y();
        }
        if (this.getSeekingStrength() > 0.0f) {
            Vec3d velocity = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            RayTraceResult hit = RayTracer.rayTrace(this.field_70170_p, this.func_174791_d(), this.func_174791_d().func_178787_e(velocity.func_186678_a(15.0)), this.getSeekingStrength(), false, true, false, EntityLivingBase.class, RayTracer.ignoreEntityFilter(null));
            if (hit != null && hit.field_72308_g != null && AllyDesignationSystem.isValidTarget((Entity)this.func_85052_h(), hit.field_72308_g)) {
                Vec3d direction = new Vec3d(hit.field_72308_g.field_70165_t, hit.field_72308_g.field_70163_u + (double)(hit.field_72308_g.field_70131_O / 2.0f), hit.field_72308_g.field_70161_v).func_178788_d(this.func_174791_d()).func_72432_b().func_186678_a(velocity.func_72433_c());
                this.field_70159_w += 2.0 * (direction.field_72450_a - this.field_70159_w) / 15.0;
                this.field_70181_x += 2.0 * (direction.field_72448_b - this.field_70181_x) / 15.0;
                this.field_70179_y += 2.0 * (direction.field_72449_c - this.field_70179_y) / 15.0;
            }
        }
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.damageMultiplier = nbttagcompound.func_74760_g("damageMultiplier");
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74776_a("damageMultiplier", this.damageMultiplier);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.func_85052_h() == null ? -1 : this.func_85052_h().func_145782_y());
    }

    public void readSpawnData(ByteBuf data) {
        int id = data.readInt();
        if (id == -1) {
            return;
        }
        Entity entity = this.field_70170_p.func_73045_a(id);
        if (entity instanceof EntityLivingBase) {
            this.field_70192_c = (EntityLivingBase)entity;
        }
        this.field_184539_c = this.field_70192_c;
    }

    public SoundCategory func_184176_by() {
        return WizardrySounds.SPELLS;
    }

    public abstract int getLifetime();
}

