/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.entity.construct.EntityBubble;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Bubble
extends SpellRay {
    public Bubble() {
        super("bubble", false, EnumAction.NONE);
        this.soundValues(0.5f, 1.1f, 0.2f);
        this.addProperties("duration");
    }

    @Override
    protected SoundEvent[] createSounds() {
        return this.createSoundsWithSuffixes("shoot", "splash");
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (WizardryUtilities.isLiving(target) && !world.field_72995_K) {
            target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.MAGIC), 1.0f);
            EntityBubble bubble = new EntityBubble(world);
            bubble.func_70107_b(target.field_70165_t, target.field_70163_u, target.field_70161_v);
            bubble.setCaster(caster);
            bubble.lifetime = (int)(this.getProperty("duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
            bubble.isDarkOrb = false;
            bubble.damageMultiplier = modifiers.get("potency");
            world.func_72838_d((Entity)bubble);
            target.func_184220_m((Entity)bubble);
        }
        return true;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        world.func_175688_a(EnumParticleTypes.WATER_SPLASH, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        ParticleBuilder.create(ParticleBuilder.Type.MAGIC_BUBBLE).pos(x, y, z).spawn(world);
    }
}

