/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FontOfMana
extends Spell {
    public FontOfMana() {
        super("font_of_mana", EnumAction.BOW, false);
        this.soundValues(0.7f, 1.2f, 0.4f);
        this.addProperties("effect_radius", "effect_duration", "effect_strength");
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        double maxRadius = this.getProperty("effect_radius").doubleValue();
        List<EntityPlayer> targets = WizardryUtilities.getEntitiesWithinRadius(maxRadius * (double)modifiers.get(WizardryItems.blast_upgrade), caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world, EntityPlayer.class);
        for (EntityPlayer target : targets) {
            if (!AllyDesignationSystem.isPlayerAlly(caster, target) && target != caster) continue;
            target.func_70690_d(new PotionEffect(WizardryPotions.font_of_mana, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)), (int)((float)this.getProperty("effect_strength").intValue() + (modifiers.get("potency") - 1.0f) * 2.0f)));
        }
        if (world.field_72995_K) {
            int i = 0;
            while ((float)i < 100.0f * modifiers.get(WizardryItems.blast_upgrade)) {
                double radius = (1.0 + world.field_73012_v.nextDouble() * (maxRadius - 1.0)) * (double)modifiers.get(WizardryItems.blast_upgrade);
                float angle = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
                float hue = world.field_73012_v.nextFloat() * 0.4f;
                double x = caster.field_70165_t + radius * (double)MathHelper.func_76134_b((float)angle);
                double y = caster.func_174813_aQ().field_72338_b;
                double z = caster.field_70161_v + radius * (double)MathHelper.func_76126_a((float)angle);
                ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.03, 0.0).time(50).clr(1.0f, 1.0f - hue, 0.6f + hue).spawn(world);
                ++i;
            }
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        if (event.getCaster() != null && event.getCaster().func_70644_a(WizardryPotions.font_of_mana)) {
            event.getModifiers().set(WizardryItems.cooldown_upgrade, event.getModifiers().get(WizardryItems.cooldown_upgrade) / (float)(2 + event.getCaster().func_70660_b(WizardryPotions.font_of_mana).func_76458_c()), false);
        }
    }
}

