/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class GroupHeal
extends Spell {
    public GroupHeal() {
        super("group_heal", EnumAction.BOW, false);
        this.soundValues(0.7f, 1.2f, 0.4f);
        this.addProperties("effect_radius", "health");
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        boolean flag = false;
        List<EntityLivingBase> targets = WizardryUtilities.getEntitiesWithinRadius(this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade), caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world);
        for (EntityLivingBase target : targets) {
            if (target != caster && !AllyDesignationSystem.isAllied(caster, target) || !(target.func_110143_aJ() < target.func_110138_aP()) || !(target.func_110143_aJ() > 0.0f)) continue;
            target.func_70691_i(this.getProperty("health").floatValue() * modifiers.get("potency"));
            if (world.field_72995_K) {
                ParticleBuilder.spawnHealParticles(world, target);
            }
            this.playSound(world, target, ticksInUse, -1, modifiers, new String[0]);
            flag = true;
        }
        return flag;
    }
}

