/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class Intimidate
extends Spell {
    public static final String NBT_KEY = "fearedEntity";
    private static final double BASE_AVOID_DISTANCE = 16.0;
    private static final double AVOID_DISTANCE_PER_LEVEL = 4.0;

    public Intimidate() {
        super("intimidate", EnumAction.BOW, false);
        this.addProperties("effect_radius", "effect_duration", "effect_strength");
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            List<EntityCreature> entities = WizardryUtilities.getEntitiesWithinRadius(this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.range_upgrade), caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world, EntityCreature.class);
            for (EntityCreature target : entities) {
                int bonusAmplifier = SpellBuff.getStandardBonusAmplifier(modifiers.get("potency"));
                NBTTagCompound entityNBT = target.getEntityData();
                if (entityNBT != null) {
                    entityNBT.func_186854_a(NBT_KEY, caster.func_110124_au());
                }
                target.func_70690_d(new PotionEffect(WizardryPotions.fear, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)), this.getProperty("effect_strength").intValue() + bonusAmplifier));
            }
        } else {
            for (int i = 0; i < 30; ++i) {
                double x = caster.field_70165_t - 1.0 + world.field_73012_v.nextDouble() * 2.0;
                double y = caster.func_174813_aQ().field_72338_b + 1.5 + world.field_73012_v.nextDouble() * 0.5;
                double z = caster.field_70161_v - 1.0 + world.field_73012_v.nextDouble() * 2.0;
                ParticleBuilder.create(ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(0.9f, 0.1f, 0.0f).spawn(world);
            }
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    public static boolean runAway(EntityCreature target, EntityLivingBase caster, double distance) {
        if ((double)target.func_70032_d((Entity)caster) < distance) {
            PathPoint point;
            Vec3d Vec3d2 = RandomPositionGenerator.func_75461_b((EntityCreature)target, (int)((int)distance), (int)((int)(distance / 2.0)), (Vec3d)new Vec3d(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v));
            if (Vec3d2 == null) {
                return false;
            }
            boolean flag = true;
            if (!target.func_70661_as().func_75500_f() && (point = target.func_70661_as().func_75505_d().func_75870_c()) != null) {
                flag = caster.func_70011_f((double)point.field_75839_a, (double)point.field_75837_b, (double)point.field_75838_c) < distance;
            }
            target.func_70624_b(null);
            if (flag) {
                return target.func_70661_as().func_75492_a(Vec3d2.field_72450_a, Vec3d2.field_72448_b, Vec3d2.field_72449_c, 1.25);
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().func_70644_a(WizardryPotions.fear) && event.getEntityLiving() instanceof EntityCreature) {
            Entity caster;
            NBTTagCompound entityNBT = event.getEntityLiving().getEntityData();
            EntityCreature creature = (EntityCreature)event.getEntityLiving();
            if (entityNBT != null && entityNBT.func_186855_b(NBT_KEY) && (caster = WizardryUtilities.getEntityByUUID(creature.field_70170_p, entityNBT.func_186857_a(NBT_KEY))) instanceof EntityLivingBase) {
                double distance = 16.0 + 4.0 * (double)event.getEntityLiving().func_70660_b(WizardryPotions.fear).func_76458_c();
                Intimidate.runAway(creature, (EntityLivingBase)caster, distance);
            }
        }
    }
}

