/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class RayOfPurification
extends SpellRay {
    public static final String UNDEAD_DAMAGE_MULTIPLIER = "undead_damage_multiplier";

    public RayOfPurification() {
        super("ray_of_purification", true, EnumAction.NONE);
        this.addProperties("damage", "effect_duration", "burn_duration", UNDEAD_DAMAGE_MULTIPLIER);
    }

    @Override
    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    @Override
    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    @Override
    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (WizardryUtilities.isLiving(target)) {
            if (MagicDamage.isEntityImmune(MagicDamage.DamageType.RADIANT, target)) {
                if (!world.field_72995_K && ticksInUse == 1 && caster instanceof EntityPlayer) {
                    ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
                }
            } else {
                float damage = this.getProperty("damage").floatValue() * modifiers.get("potency");
                if (((EntityLivingBase)target).func_70662_br()) {
                    target.func_70015_d((int)(this.getProperty("burn_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
                    damage *= this.getProperty(UNDEAD_DAMAGE_MULTIPLIER).floatValue();
                }
                WizardryUtilities.attackEntityWithoutKnockback(target, MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.RADIANT), damage);
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76440_q, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade))));
            }
        }
        return true;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    @Override
    protected void spawnParticleRay(World world, Vec3d origin, Vec3d direction, EntityLivingBase caster, double distance) {
        if (caster != null) {
            ParticleBuilder.create(ParticleBuilder.Type.BEAM).entity((Entity)caster).pos(origin.func_178788_d(caster.func_174791_d())).length(distance).clr(1.0f, 0.6f + 0.3f * world.field_73012_v.nextFloat(), 0.2f).scale(MathHelper.func_76126_a((float)((float)world.func_82737_E() * 0.2f)) * 0.1f + 1.4f).spawn(world);
        } else {
            ParticleBuilder.create(ParticleBuilder.Type.BEAM).pos(origin).target(origin.func_178787_e(direction.func_186678_a(distance))).clr(1.0f, 0.6f + 0.3f * world.field_73012_v.nextFloat(), 0.2f).scale(MathHelper.func_76126_a((float)((float)world.func_82737_E() * 0.2f)) * 0.1f + 1.4f).spawn(world);
        }
    }
}

