/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.integration.DamageSafetyChecker;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ShadowWard
extends Spell {
    public static final String REFLECTED_FRACTION = "reflected_fraction";

    public ShadowWard() {
        super("shadow_ward", EnumAction.BLOCK, true);
        this.addProperties(REFLECTED_FRACTION);
        this.soundValues(0.6f, 1.0f, 0.0f);
    }

    @Override
    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    @Override
    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    @Override
    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (world.field_72995_K) {
            double dx = -1.0f + 2.0f * world.field_73012_v.nextFloat();
            double dy = -1.0f + world.field_73012_v.nextFloat();
            double dz = -1.0f + 2.0f * world.field_73012_v.nextFloat();
            world.func_175688_a(EnumParticleTypes.PORTAL, caster.field_70165_t, caster.func_174813_aQ().field_72338_b + (double)caster.func_70047_e(), caster.field_70161_v, dx, dy, dz, new int[0]);
        }
        if (ticksInUse % 50 == 0) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        }
        return true;
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        if (!(event.getSource() == null || !(event.getSource().func_76346_g() instanceof EntityLivingBase) || !WizardryUtilities.isCasting(event.getEntityLiving(), Spells.shadow_ward) || event.getSource().func_76363_c() || event.getSource() instanceof IElementalDamage && ((IElementalDamage)event.getSource()).isRetaliatory())) {
            event.setCanceled(true);
            float reflectedFraction = MathHelper.func_76131_a((float)Spells.shadow_ward.getProperty(REFLECTED_FRACTION).floatValue(), (float)0.0f, (float)1.0f);
            DamageSafetyChecker.attackEntitySafely(event.getEntity(), DamageSource.field_76376_m, event.getAmount() * (1.0f - reflectedFraction), event.getSource().func_76355_l());
            event.getSource().func_76346_g().func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)event.getEntityLiving(), MagicDamage.DamageType.MAGIC, true), event.getAmount() * reflectedFraction);
        }
    }
}

