/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.entity.projectile.EntityMagicArrow;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class SpellArrow<T extends EntityMagicArrow>
extends Spell {
    private static final float DISPENSER_INACCURACY = 1.0f;
    private static final float FALLBACK_VELOCITY = 2.0f;
    protected final Function<World, T> arrowFactory;

    public SpellArrow(String name, Function<World, T> arrowFactory) {
        this("ebwizardry", name, arrowFactory);
    }

    public SpellArrow(String modID, String name, Function<World, T> arrowFactory) {
        super(modID, name, EnumAction.NONE, false);
        this.arrowFactory = arrowFactory;
        this.addProperties("range");
        this.npcSelector((e, o) -> true);
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    protected float calculateVelocity(EntityMagicArrow projectile, SpellModifiers modifiers, float launchHeight) {
        float range = this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade);
        if (!projectile.doGravity()) {
            if (projectile.getLifetime() <= 0) {
                return 2.0f;
            }
            return range / (float)projectile.getLifetime();
        }
        float g = 0.05f;
        return range / MathHelper.func_76129_c((float)(2.0f * launchHeight / g));
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            EntityMagicArrow projectile = (EntityMagicArrow)((Object)this.arrowFactory.apply(world));
            projectile.aim((EntityLivingBase)caster, this.calculateVelocity(projectile, modifiers, caster.func_70047_e() - 0.1f));
            projectile.damageMultiplier = modifiers.get("potency");
            this.addArrowExtras(projectile, (EntityLivingBase)caster, modifiers);
            world.func_72838_d((Entity)projectile);
        }
        caster.func_184609_a(hand);
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            if (!world.field_72995_K) {
                EntityMagicArrow projectile = (EntityMagicArrow)((Object)this.arrowFactory.apply(world));
                int aimingError = caster instanceof ISpellCaster ? ((ISpellCaster)caster).getAimingError(world.func_175659_aa()) : WizardryUtilities.getDefaultAimingError(world.func_175659_aa());
                projectile.aim((EntityLivingBase)caster, (Entity)target, this.calculateVelocity(projectile, modifiers, caster.func_70047_e() - 0.1f), aimingError);
                projectile.damageMultiplier = modifiers.get("potency");
                this.addArrowExtras(projectile, (EntityLivingBase)caster, modifiers);
                world.func_72838_d((Entity)projectile);
            }
            caster.func_184609_a(hand);
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            EntityMagicArrow projectile = (EntityMagicArrow)((Object)this.arrowFactory.apply(world));
            projectile.func_70107_b(x, y, z);
            Vec3i vec = direction.func_176730_m();
            projectile.func_70186_c(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p(), this.calculateVelocity(projectile, modifiers, 0.375f), 1.0f);
            projectile.damageMultiplier = modifiers.get("potency");
            this.addArrowExtras(projectile, null, modifiers);
            world.func_72838_d((Entity)projectile);
        }
        this.playSound(world, x - (double)direction.func_82601_c(), y - (double)direction.func_96559_d(), z - (double)direction.func_82599_e(), ticksInUse, duration, modifiers, new String[0]);
        return true;
    }

    protected void addArrowExtras(T arrow, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
    }
}

