/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.entity.construct.EntityMagicConstruct;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellConstruct;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class SpellConstructRanged<T extends EntityMagicConstruct>
extends SpellConstruct<T> {
    protected boolean hitLiquids = false;
    protected boolean ignoreUncollidables = false;

    public SpellConstructRanged(String name, Function<World, T> constructFactory, boolean permanent) {
        this("ebwizardry", name, constructFactory, permanent);
    }

    public SpellConstructRanged(String modID, String name, Function<World, T> constructFactory, boolean permanent) {
        super(modID, name, EnumAction.NONE, constructFactory, permanent);
        this.addProperties("range");
        this.npcSelector((e, o) -> true);
    }

    public Spell hitLiquids(boolean hitLiquids) {
        this.hitLiquids = hitLiquids;
        return this;
    }

    public Spell ignoreUncollidables(boolean ignoreUncollidables) {
        this.ignoreUncollidables = ignoreUncollidables;
        return this;
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        double range = this.getProperty("range").doubleValue() * (double)modifiers.get(WizardryItems.range_upgrade);
        RayTraceResult rayTrace = RayTracer.standardBlockRayTrace(world, (EntityLivingBase)caster, range, this.hitLiquids, this.ignoreUncollidables, false);
        if (!(rayTrace == null || rayTrace.field_72313_a != RayTraceResult.Type.BLOCK || rayTrace.field_178784_b != EnumFacing.UP && this.requiresFloor)) {
            double z;
            double y;
            double x;
            if (!world.field_72995_K && !this.spawnConstruct(world, x = rayTrace.field_72307_f.field_72450_a, y = rayTrace.field_72307_f.field_72448_b, z = rayTrace.field_72307_f.field_72449_c, rayTrace.field_178784_b, (EntityLivingBase)caster, modifiers)) {
                return false;
            }
        } else if (!this.requiresFloor) {
            if (!world.field_72995_K) {
                double z;
                Vec3d look = caster.func_70040_Z();
                double x = caster.field_70165_t + look.field_72450_a * range;
                double y = caster.func_174813_aQ().field_72338_b + (double)caster.func_70047_e() + look.field_72448_b * range;
                if (!this.spawnConstruct(world, x, y, z = caster.field_70161_v + look.field_72449_c * range, null, (EntityLivingBase)caster, modifiers)) {
                    return false;
                }
            }
        } else {
            return false;
        }
        caster.func_184609_a(hand);
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        double range = this.getProperty("range").doubleValue() * (double)modifiers.get(WizardryItems.range_upgrade);
        if (target != null && (double)caster.func_70032_d((Entity)target) <= range) {
            if (!world.field_72995_K) {
                double x = target.field_70165_t;
                double y = target.field_70163_u;
                double z = target.field_70161_v;
                EnumFacing side = null;
                if (!target.field_70122_E && this.requiresFloor) {
                    Integer floor = WizardryUtilities.getNearestFloor(world, new BlockPos(x, y, z), 3);
                    if (floor == null) {
                        return false;
                    }
                    y = floor.intValue();
                    side = EnumFacing.UP;
                }
                if (!this.spawnConstruct(world, x, y, z, side, (EntityLivingBase)caster, modifiers)) {
                    return false;
                }
            }
            caster.func_184609_a(hand);
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        double range = this.getProperty("range").doubleValue() * (double)modifiers.get(WizardryItems.range_upgrade);
        Vec3d origin = new Vec3d(x, y, z);
        Vec3d endpoint = origin.func_178787_e(new Vec3d(direction.func_176730_m()).func_186678_a(range));
        RayTraceResult rayTrace = world.func_147447_a(origin, endpoint, this.hitLiquids, this.ignoreUncollidables, false);
        if (!(rayTrace == null || rayTrace.field_72313_a != RayTraceResult.Type.BLOCK || rayTrace.field_178784_b != EnumFacing.UP && this.requiresFloor)) {
            double z1;
            double y1;
            double x1;
            if (!world.field_72995_K && !this.spawnConstruct(world, x1 = rayTrace.field_72307_f.field_72450_a, y1 = rayTrace.field_72307_f.field_72448_b, z1 = rayTrace.field_72307_f.field_72449_c, rayTrace.field_178784_b, null, modifiers)) {
                return false;
            }
        } else if (!this.requiresFloor) {
            if (!world.field_72995_K && !this.spawnConstruct(world, endpoint.field_72450_a, endpoint.field_72448_b, endpoint.field_72449_c, null, null, modifiers)) {
                return false;
            }
        } else {
            return false;
        }
        this.playSound(world, x - (double)direction.func_82601_c(), y - (double)direction.func_96559_d(), z - (double)direction.func_82599_e(), ticksInUse, duration, modifiers, new String[0]);
        return true;
    }
}

