/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.misc.IWorldData;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityEnderCrate;
import de.ellpeck.naturesaura.blocks.tiles.render.RenderEnderCrate;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.reg.ITESRProvider;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnderCrate
extends BlockContainerImpl
implements ITESRProvider {
    private static final ThreadLocal<WeakReference<World>> CACHED_WORLD = new ThreadLocal();

    public BlockEnderCrate() {
        super(Material.field_151576_e, "ender_crate", TileEntityEnderCrate.class, "ender_crate");
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(5.0f);
        this.func_149715_a(0.75f);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static String getEnderName(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return "";
        }
        NBTTagCompound compound = stack.func_77978_p();
        return compound.func_74779_i("naturesaura:ender_name");
    }

    @SideOnly(value=Side.CLIENT)
    public static void addEnderNameInfo(ItemStack stack, List<String> tooltip) {
        String name = BlockEnderCrate.getEnderName(stack);
        if (name != null && !name.isEmpty()) {
            tooltip.add(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"info.naturesaura.ender_name", (Object[])new Object[]{TextFormatting.ITALIC + name + TextFormatting.RESET}));
        } else {
            tooltip.add(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"info.naturesaura.ender_name.missing", (Object[])new Object[0]));
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        World world = event.getWorld();
        IBlockState state = world.func_180495_p(pos = event.getPos());
        if (state.func_177230_c() instanceof BlockAnvil) {
            CACHED_WORLD.set(new WeakReference<World>(world));
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        WeakReference<World> world = CACHED_WORLD.get();
        if (world == null || world.get() == null) {
            return;
        }
        ItemStack stack = event.getLeft();
        if (stack.func_77973_b() != Item.func_150898_a((Block)this) && stack.func_77973_b() != ModItems.ENDER_ACCESS) {
            return;
        }
        ItemStack second = event.getRight();
        if (second.func_77973_b() != Items.field_151061_bv || second.func_190916_E() < stack.func_190916_E()) {
            return;
        }
        String name = event.getName();
        if (name == null || name.isEmpty()) {
            return;
        }
        if (IWorldData.getOverworldData((World)world.get()).isEnderStorageLocked(name)) {
            return;
        }
        ItemStack output = stack.func_77946_l();
        if (!output.func_77942_o()) {
            output.func_77982_d(new NBTTagCompound());
        }
        output.func_77978_p().func_74778_a("naturesaura:ender_name", name);
        event.setOutput(output);
        event.setMaterialCost(stack.func_190916_E());
        event.setCost(1);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityEnderCrate crate;
        TileEntity tile;
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityEnderCrate && (crate = (TileEntityEnderCrate)tile).canOpen()) {
            crate.drainAura(10000);
            playerIn.openGui((Object)"naturesaura", 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        BlockEnderCrate.addEnderNameInfo(stack, tooltip);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        for (int i = 0; i < 3; ++i) {
            int j = rand.nextInt(2) * 2 - 1;
            int k = rand.nextInt(2) * 2 - 1;
            double d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)k;
            double d3 = rand.nextFloat() * (float)j;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.125;
            double d5 = rand.nextFloat() * (float)k;
            worldIn.func_175688_a(EnumParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5, new int[0]);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Tuple<Class, TileEntitySpecialRenderer> getTESR() {
        return new Tuple(TileEntityEnderCrate.class, (Object)new RenderEnderCrate());
    }
}

