/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.blocks.BlockAncientLeaves;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.reg.IColorProvidingBlock;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.IModelProvider;
import de.ellpeck.naturesaura.reg.ModRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGoldenLeaves
extends BlockLeaves
implements IModItem,
IModelProvider,
IColorProvidingBlock,
IColorProvidingItem {
    private static final int HIGHEST_STAGE = 3;
    private static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)3);

    public BlockGoldenLeaves() {
        this.field_185686_c = true;
        ModRegistry.add(this);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.field_151647_F;
    }

    @Override
    public String getBaseName() {
        return "golden_leaves";
    }

    @Override
    public void onPreInit(FMLPreInitializationEvent event) {
    }

    @Override
    public void onInit(FMLInitializationEvent event) {
    }

    @Override
    public void onPostInit(FMLPostInitializationEvent event) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if ((Integer)stateIn.func_177229_b((IProperty)STAGE) == 3 && rand.nextFloat() >= 0.75f) {
            NaturesAuraAPI.instance().spawnMagicParticle((float)pos.func_177958_n() + rand.nextFloat(), (float)pos.func_177956_o() + rand.nextFloat(), (float)pos.func_177952_p() + rand.nextFloat(), 0.0, 0.0, 0.0, 0xF2FF00, 0.5f + rand.nextFloat(), 50, 0.0f, false, true);
        }
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        NonNullList drops = NonNullList.func_191196_a();
        this.getDrops((NonNullList<ItemStack>)drops, world, pos, world.func_180495_p(pos), fortune);
        return drops;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176236_b, field_176237_a, STAGE});
    }

    public IBlockState func_176203_a(int meta) {
        boolean check = (meta & 4) != 0;
        boolean decay = (meta & 8) != 0;
        int stage = meta & 3;
        return this.func_176223_P().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(check)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(decay)).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(stage));
    }

    public int func_176201_c(IBlockState state) {
        boolean check = (Boolean)state.func_177229_b((IProperty)field_176236_b);
        boolean decay = (Boolean)state.func_177229_b((IProperty)field_176237_a);
        return (check ? 1 : 0) << 3 | (decay ? 1 : 0) << 2 | (Integer)state.func_177229_b((IProperty)STAGE);
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(true)), 4);
        }
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return (state, worldIn, pos, tintIndex) -> {
            int color = 0xF2FF00;
            if (state != null && worldIn != null && pos != null) {
                int foliage = BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos);
                return Helper.blendColors(color, foliage, (float)((Integer)state.func_177229_b((IProperty)STAGE)).intValue() / 3.0f);
            }
            return color;
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return (stack, tintIndex) -> 0xF2FF00;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand;
        Random random = rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        if ((Integer)state.func_177229_b((IProperty)STAGE) < 3) {
            if (rand.nextFloat() >= 0.75f) {
                drops.add((Object)new ItemStack(ModItems.GOLD_FIBER));
            }
        } else if (rand.nextFloat() >= 0.25f) {
            drops.add((Object)new ItemStack(ModItems.GOLD_LEAF));
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        if (!worldIn.field_72995_K) {
            BlockPos offset;
            int stage = (Integer)state.func_177229_b((IProperty)STAGE);
            if (stage < 3) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(stage + 1)));
            }
            if (stage > 1 && worldIn.func_175667_e(offset = pos.func_177972_a(EnumFacing.func_176741_a((Random)rand)))) {
                BlockGoldenLeaves.convert(worldIn, offset);
            }
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public static boolean convert(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) && !(state.func_177230_c() instanceof BlockAncientLeaves) && !(state.func_177230_c() instanceof BlockGoldenLeaves)) {
            if (!world.field_72995_K) {
                world.func_175656_a(pos, ModBlocks.GOLDEN_LEAVES.func_176223_P().func_177226_a((IProperty)field_176236_b, (Comparable)(state.func_177227_a().contains(field_176236_b) ? (Boolean)state.func_177229_b((IProperty)field_176236_b) : Boolean.valueOf(false))).func_177226_a((IProperty)field_176237_a, (Comparable)(state.func_177227_a().contains(field_176237_a) ? (Boolean)state.func_177229_b((IProperty)field_176237_a) : Boolean.valueOf(false))));
            }
            return true;
        }
        return false;
    }
}

