/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticleStream;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityFieldCreator
extends TileEntityImpl
implements ITickable {
    public BlockPos connectionOffset;
    public boolean isMain;
    public boolean isCharged;
    private int chargeTimer;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 10L != 0L) {
            return;
        }
        BlockPos connectedPos = this.getConnectedPos();
        if (connectedPos == null || !this.field_145850_b.func_175667_e(connectedPos)) {
            return;
        }
        TileEntity other = this.field_145850_b.func_175625_s(connectedPos);
        if (!(this.isCloseEnough(connectedPos) && other instanceof TileEntityFieldCreator && this.field_174879_c.equals((Object)((TileEntityFieldCreator)other).getConnectedPos()))) {
            this.connectionOffset = null;
            this.chargeTimer = 0;
            this.isCharged = false;
            this.isMain = false;
            this.sendToClients();
            return;
        }
        if (!this.isMain) {
            return;
        }
        TileEntityFieldCreator creator = (TileEntityFieldCreator)other;
        if (this.redstonePower <= 0 && creator.redstonePower <= 0) {
            this.chargeTimer = 0;
            if (this.isCharged) {
                this.isCharged = false;
                this.sendToClients();
                creator.isCharged = false;
                creator.sendToClients();
            }
            return;
        }
        BlockPos spot = IAuraChunk.getHighestSpot(this.field_145850_b, this.field_174879_c, 32, this.field_174879_c);
        IAuraChunk chunk = IAuraChunk.getAuraChunk(this.field_145850_b, spot);
        if (!this.isCharged) {
            this.chargeTimer += 10;
            if (this.chargeTimer >= 150) {
                this.chargeTimer = 0;
                this.isCharged = true;
                this.sendToClients();
                creator.isCharged = true;
                creator.sendToClients();
            }
            chunk.drainAura(spot, 300);
            this.sendParticles();
        } else {
            if (this.field_145850_b.func_82737_E() % 40L == 0L) {
                chunk.drainAura(spot, 100);
            }
            boolean shears = this.shears() || creator.shears();
            Vec3d dist = new Vec3d((double)(this.field_174879_c.func_177958_n() - connectedPos.func_177958_n()), (double)(this.field_174879_c.func_177956_o() - connectedPos.func_177956_o()), (double)(this.field_174879_c.func_177952_p() - connectedPos.func_177952_p()));
            double length = dist.func_72433_c();
            Vec3d normal = new Vec3d(dist.field_72450_a / length, dist.field_72448_b / length, dist.field_72449_c / length);
            for (int i = MathHelper.func_76128_c((double)length); i > 0; --i) {
                Object drops;
                boolean shearBlock;
                FakePlayer fake;
                IBlockState state;
                Block block;
                Vec3d scaled = normal.func_186678_a((double)i);
                BlockPos pos = connectedPos.func_177982_a(MathHelper.func_76128_c((double)(scaled.field_72450_a + 0.5)), MathHelper.func_76128_c((double)(scaled.field_72448_b + 0.5)), MathHelper.func_76128_c((double)(scaled.field_72449_c + 0.5)));
                if (pos.equals((Object)this.field_174879_c) || pos.equals((Object)connectedPos) || (block = (state = this.field_145850_b.func_180495_p(pos)).func_177230_c()).isAir(state, (IBlockAccess)this.field_145850_b, pos) || block instanceof BlockLiquid || block instanceof IFluidBlock || !(state.func_185887_b(this.field_145850_b, pos) >= 0.0f) || MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(this.field_145850_b, pos, state, (EntityPlayer)(fake = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.field_145850_b)))))) continue;
                boolean bl = shearBlock = shears && block instanceof IShearable;
                if (shearBlock && ((IShearable)block).isShearable(ItemStack.field_190927_a, (IBlockAccess)this.field_145850_b, pos)) {
                    drops = ((IShearable)block).onSheared(ItemStack.field_190927_a, (IBlockAccess)this.field_145850_b, pos, 0);
                } else {
                    drops = NonNullList.func_191196_a();
                    block.getDrops((NonNullList)drops, (IBlockAccess)this.field_145850_b, pos, state, 0);
                }
                float chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)this.field_145850_b, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)fake);
                if (!(chance > 0.0f) || !(this.field_145850_b.field_73012_v.nextFloat() <= chance)) continue;
                this.field_145850_b.func_175655_b(pos, false);
                Iterator iterator = drops.iterator();
                while (iterator.hasNext()) {
                    ItemStack stack = (ItemStack)iterator.next();
                    Block.func_180635_a((World)this.field_145850_b, (BlockPos)pos, (ItemStack)stack);
                }
                chunk.drainAura(spot, shearBlock ? 1000 : 300);
                this.sendParticles();
            }
        }
    }

    public boolean shears() {
        List<EntityItemFrame> frames = Helper.getAttachedItemFrames(this.field_145850_b, this.field_174879_c);
        for (EntityItemFrame frame : frames) {
            ItemStack stack = frame.func_82335_i();
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemShears)) continue;
            return true;
        }
        return false;
    }

    private void sendParticles() {
        for (int j = 0; j < 2; ++j) {
            BlockPos p = j == 0 ? this.field_174879_c : this.getConnectedPos();
            PacketHandler.sendToAllAround(this.field_145850_b, p, 32, new PacketParticleStream((float)p.func_177958_n() + (float)this.field_145850_b.field_73012_v.nextGaussian() * 3.0f, (float)(p.func_177956_o() + 1) + this.field_145850_b.field_73012_v.nextFloat() * 3.0f, (float)p.func_177952_p() + (float)this.field_145850_b.field_73012_v.nextGaussian() * 3.0f, (float)p.func_177958_n() + 0.5f, (float)p.func_177956_o() + 0.5f, (float)p.func_177952_p() + 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.07f + 0.07f, IAuraType.forWorld(this.field_145850_b).getColor(), this.field_145850_b.field_73012_v.nextFloat() + 0.5f));
        }
    }

    public boolean isCloseEnough(BlockPos pos) {
        int range = ModConfig.general.fieldCreatorRange + 1;
        return this.field_174879_c.func_177951_i((Vec3i)pos) <= (double)(range * range);
    }

    public BlockPos getConnectedPos() {
        if (this.connectionOffset == null) {
            return null;
        }
        return this.field_174879_c.func_177971_a((Vec3i)this.connectionOffset);
    }

    @Override
    public void writeNBT(NBTTagCompound compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            if (this.connectionOffset != null) {
                compound.func_74772_a("connection", this.connectionOffset.func_177986_g());
            }
            compound.func_74757_a("main", this.isMain);
            compound.func_74757_a("charged", this.isCharged);
            if (type == TileEntityImpl.SaveType.TILE) {
                compound.func_74768_a("timer", this.chargeTimer);
            }
        }
    }

    @Override
    public void readNBT(NBTTagCompound compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            this.connectionOffset = compound.func_74764_b("connection") ? BlockPos.func_177969_a((long)compound.func_74763_f("connection")) : null;
            this.isMain = compound.func_74767_n("main");
            this.isCharged = compound.func_74767_n("charged");
            if (type == TileEntityImpl.SaveType.TILE) {
                this.chargeTimer = compound.func_74762_e("timer");
            }
        }
    }
}

