/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityRFConverter
extends TileEntityImpl
implements ITickable {
    public final RFStorage storage = new RFStorage();
    private int lastEnergy;

    @Override
    public void writeNBT(NBTTagCompound compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        compound.func_74768_a("energy", this.storage.getEnergyStored());
    }

    @Override
    public void readNBT(NBTTagCompound compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        this.storage.setEnergy(compound.func_74762_e("energy"));
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int emptyPart;
            if (this.lastEnergy != this.storage.getEnergyStored() && this.field_145850_b.func_82737_E() % 10L == 0L) {
                this.sendToClients();
                this.lastEnergy = this.storage.getEnergyStored();
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                int extracted;
                int canStore;
                IEnergyStorage storage;
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (tile == null || !tile.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()) || (storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) == null || (canStore = storage.receiveEnergy(Integer.MAX_VALUE, true)) <= 0 || (extracted = this.storage.extractEnergy(canStore, false)) <= 0) continue;
                storage.receiveEnergy(extracted, false);
                break;
            }
            if ((emptyPart = this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()) <= 0) {
                return;
            }
            if (this.field_145850_b.func_82737_E() % 20L != 0L) {
                return;
            }
            if (!Multiblocks.RF_CONVERTER.isComplete(this.field_145850_b, this.field_174879_c)) {
                return;
            }
            int aura = IAuraChunk.getAuraInArea(this.field_145850_b, this.field_174879_c, 45);
            if (aura <= 1000000) {
                return;
            }
            int amountToGen = Math.min(Math.min(10000, aura / 1000), emptyPart);
            int amountToUse = MathHelper.func_76123_f((float)((float)amountToGen / ModConfig.general.auraToRFRatio));
            this.storage.setEnergy(this.storage.getEnergyStored() + amountToGen);
            BlockPos pos = IAuraChunk.getHighestSpot(this.field_145850_b, this.field_174879_c, 45, this.field_174879_c);
            IAuraChunk.getAuraChunk(this.field_145850_b, pos).drainAura(pos, amountToUse);
            PacketHandler.sendToAllAround(this.field_145850_b, this.field_174879_c, 32, new PacketParticles(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 20, new int[0]));
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.storage);
        }
        return super.getCapability(capability, facing);
    }

    public static class RFStorage
    extends EnergyStorage {
        public RFStorage() {
            super(50000, 0, 2000);
        }

        public void setEnergy(int energy) {
            this.energy = energy;
        }
    }
}

