/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class CacheRechargeEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "cache_recharge");
    private int amount;
    private AxisAlignedBB bb;

    private boolean calcValues(World world, BlockPos pos, Integer spot) {
        if (spot < 100000) {
            return false;
        }
        int aura = IAuraChunk.getAuraInArea(world, pos, 20);
        if (aura < 1500000) {
            return false;
        }
        int dist = MathHelper.func_76125_a((int)(aura / 3500), (int)3, (int)15);
        this.bb = new AxisAlignedBB(pos).func_186662_g((double)dist);
        this.amount = MathHelper.func_76123_f((float)((float)aura / 250.0f / (float)IAuraChunk.getSpotAmountInArea(world, pos, 20)));
        return true;
    }

    @Override
    public int isActiveHere(EntityPlayer player, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.field_70170_p, pos, spot)) {
            return -1;
        }
        if (!this.bb.func_72318_a(player.func_174791_d())) {
            return -1;
        }
        if (NaturesAuraAPI.instance().isEffectPowderActive(player.field_70170_p, player.func_180425_c(), NAME)) {
            return 0;
        }
        return 1;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack(ModItems.AURA_CACHE);
    }

    @Override
    public void update(World world, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(world, pos, spot)) {
            return;
        }
        List players = world.func_72872_a(EntityPlayer.class, this.bb);
        for (EntityPlayer player : players) {
            if (NaturesAuraAPI.instance().isEffectPowderActive(world, player.func_180425_c(), NAME) || !NaturesAuraAPI.instance().insertAuraIntoPlayer(player, this.amount, true)) continue;
            NaturesAuraAPI.instance().insertAuraIntoPlayer(player, this.amount, false);
            auraChunk.drainAura(pos, this.amount);
        }
    }

    @Override
    public boolean appliesHere(Chunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return ModConfig.enabledFeatures.cacheRechargeEffect;
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

