/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ExplosionEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "explosions");
    private float strength;
    private int dist;

    private boolean calcValues(World world, BlockPos pos, Integer spot) {
        if (spot >= 0) {
            return false;
        }
        int aura = IAuraChunk.getAuraInArea(world, pos, 85);
        if (aura > -5000000) {
            return false;
        }
        int chance = 140 - Math.abs(aura) / 200000;
        if (chance > 1 && world.field_73012_v.nextInt(chance) != 0) {
            return false;
        }
        this.strength = Math.min((float)Math.abs(aura) / 5000000.0f, 5.0f);
        if (this.strength <= 0.0f) {
            return false;
        }
        this.dist = MathHelper.func_76125_a((int)(Math.abs(aura) / 200000), (int)25, (int)100);
        return true;
    }

    @Override
    public int isActiveHere(EntityPlayer player, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.field_70170_p, pos, spot)) {
            return -1;
        }
        if (player.func_174818_b(pos) > (double)(this.dist * this.dist)) {
            return -1;
        }
        return 1;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack(Blocks.field_150335_W);
    }

    @Override
    public void update(World world, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        int z;
        if (world.func_82737_E() % 40L != 0L) {
            return;
        }
        if (!this.calcValues(world, pos, spot)) {
            return;
        }
        int x = MathHelper.func_76128_c((double)((double)pos.func_177958_n() + world.field_73012_v.nextGaussian() * (double)this.dist));
        BlockPos chosenPos = new BlockPos(x, world.func_189649_b(x, z = MathHelper.func_76128_c((double)((double)pos.func_177952_p() + world.field_73012_v.nextGaussian() * (double)this.dist))), z);
        if (chosenPos.func_177951_i((Vec3i)pos) <= (double)(this.dist * this.dist) && world.func_175667_e(chosenPos)) {
            world.func_72885_a(null, (double)chosenPos.func_177958_n() + 0.5, (double)chosenPos.func_177956_o() + 0.5, (double)chosenPos.func_177952_p() + 0.5, this.strength, false, true);
        }
    }

    @Override
    public boolean appliesHere(Chunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return ModConfig.enabledFeatures.explosionEffect;
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

