/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.jei;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.recipes.AltarRecipe;
import de.ellpeck.naturesaura.api.recipes.AnimalSpawnerRecipe;
import de.ellpeck.naturesaura.api.recipes.OfferingRecipe;
import de.ellpeck.naturesaura.api.recipes.TreeRitualRecipe;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.compat.jei.altar.AltarCategory;
import de.ellpeck.naturesaura.compat.jei.altar.AltarWrapper;
import de.ellpeck.naturesaura.compat.jei.animal.AnimalSpawnerCategory;
import de.ellpeck.naturesaura.compat.jei.animal.AnimalSpawnerWrapper;
import de.ellpeck.naturesaura.compat.jei.offering.OfferingCategory;
import de.ellpeck.naturesaura.compat.jei.offering.OfferingWrapper;
import de.ellpeck.naturesaura.compat.jei.treeritual.TreeRitualCategory;
import de.ellpeck.naturesaura.compat.jei.treeritual.TreeRitualWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class JEINaturesAuraPlugin
implements IModPlugin {
    public static final String TREE_RITUAL = "naturesaura.tree_ritual";
    public static final String ALTAR = "naturesaura.altar";
    public static final String OFFERING = "naturesaura.offering";
    public static final String SPAWNER = "naturesaura.animal_spawner";

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new TreeRitualCategory(helper), new AltarCategory(helper), new OfferingCategory(helper), new AnimalSpawnerCategory(helper)});
    }

    public void register(IModRegistry registry) {
        registry.handleRecipes(TreeRitualRecipe.class, TreeRitualWrapper::new, TREE_RITUAL);
        registry.handleRecipes(AltarRecipe.class, AltarWrapper::new, ALTAR);
        registry.handleRecipes(OfferingRecipe.class, OfferingWrapper::new, OFFERING);
        registry.handleRecipes(AnimalSpawnerRecipe.class, AnimalSpawnerWrapper::new, SPAWNER);
        registry.addRecipes(NaturesAuraAPI.TREE_RITUAL_RECIPES.values(), TREE_RITUAL);
        registry.addRecipes(NaturesAuraAPI.ALTAR_RECIPES.values(), ALTAR);
        registry.addRecipes(NaturesAuraAPI.OFFERING_RECIPES.values(), OFFERING);
        registry.addRecipes(NaturesAuraAPI.ANIMAL_SPAWNER_RECIPES.values(), SPAWNER);
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.GOLD_POWDER), new String[]{TREE_RITUAL});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.WOOD_STAND), new String[]{TREE_RITUAL});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.NATURE_ALTAR), new String[]{ALTAR});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.CONVERSION_CATALYST), new String[]{ALTAR});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.OFFERING_TABLE), new String[]{OFFERING});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.ANIMAL_SPAWNER), new String[]{SPAWNER});
    }
}

