/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.patchouli;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.multiblock.Matcher;
import de.ellpeck.naturesaura.events.ClientEvents;
import de.ellpeck.naturesaura.renderers.SupporterFancyHandler;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.Collections;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.patchouli.api.BookDrawScreenEvent;
import vazkii.patchouli.api.PatchouliAPI;

public final class PatchouliCompat {
    private static final ResourceLocation BOOK = new ResourceLocation("naturesaura", "book");

    public static void preInit() {
        PatchouliAPI.instance.setConfigFlag("naturesaura:rf_converter", ModConfig.enabledFeatures.rfConverter);
        PatchouliAPI.instance.setConfigFlag("naturesaura:chunk_loader", ModConfig.enabledFeatures.chunkLoader);
    }

    public static void preInitClient() {
        MinecraftForge.EVENT_BUS.register((Object)new PatchouliCompat());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onBookDraw(BookDrawScreenEvent event) {
        String name;
        SupporterFancyHandler.FancyInfo info;
        if (event.book == null || !event.book.equals((Object)BOOK)) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        if (now.getMonth() == Month.MAY && now.getDayOfMonth() == 21) {
            int x = event.gui.field_146294_l / 2 + 136 - 16;
            int y = event.gui.field_146295_m / 2 - 90 - 26;
            RenderHelper.func_74518_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            event.gui.field_146297_k.func_110434_K().func_110577_a(ClientEvents.BOOK_GUI);
            Gui.func_146110_a((int)x, (int)y, (float)469.0f, (float)0.0f, (int)43, (int)42, (float)512.0f, (float)256.0f);
            if (event.mouseX >= x && event.mouseY >= y && event.mouseX < x + 43 && event.mouseY < y + 42) {
                GuiUtils.drawHoveringText(Collections.singletonList(TextFormatting.GOLD + "It's the author Ellpeck's birthday!"), (int)event.mouseX, (int)event.mouseY, (int)event.gui.field_146294_l, (int)event.gui.field_146295_m, (int)0, (FontRenderer)event.gui.field_146297_k.field_71466_p);
            }
        }
        if ((info = SupporterFancyHandler.FANCY_INFOS.get(name = event.gui.field_146297_k.field_71439_g.func_70005_c_())) != null) {
            int x = event.gui.field_146294_l / 2 - 136 + 20;
            int y = event.gui.field_146295_m / 2 + 90;
            RenderHelper.func_74518_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            event.gui.field_146297_k.func_110434_K().func_110577_a(ClientEvents.BOOK_GUI);
            Gui.func_146110_a((int)x, (int)y, (float)496.0f, (float)44.0f, (int)16, (int)18, (float)512.0f, (float)256.0f);
            if (info.tier == 1) {
                Gui.func_146110_a((int)x, (int)y, (float)480.0f, (float)44.0f, (int)16, (int)18, (float)512.0f, (float)256.0f);
            } else {
                float r = (float)(info.color >> 16 & 0xFF) / 255.0f;
                float g = (float)(info.color >> 8 & 0xFF) / 255.0f;
                float b = (float)(info.color & 0xFF) / 255.0f;
                GlStateManager.func_179124_c((float)r, (float)g, (float)b);
                Gui.func_146110_a((int)x, (int)y, (float)464.0f, (float)44.0f, (int)16, (int)18, (float)512.0f, (float)256.0f);
            }
            if (event.mouseX >= x && event.mouseY >= y && event.mouseX < x + 16 && event.mouseY < y + 18) {
                GuiUtils.drawHoveringText(Collections.singletonList(TextFormatting.YELLOW + "Thanks for your support, " + name + "!"), (int)event.mouseX, (int)event.mouseY, (int)event.gui.field_146294_l, (int)event.gui.field_146295_m, (int)0, (FontRenderer)event.gui.field_146297_k.field_71466_p);
            }
        }
    }

    public static void addPatchouliMultiblock(ResourceLocation name, String[][] pattern, Object ... rawMatchers) {
        for (int i = 1; i < rawMatchers.length; i += 2) {
            if (!(rawMatchers[i] instanceof Matcher)) continue;
            Matcher matcher = (Matcher)rawMatchers[i];
            Matcher.ICheck check = matcher.getCheck();
            rawMatchers[i] = check == null ? PatchouliAPI.instance.anyMatcher() : PatchouliAPI.instance.predicateMatcher(matcher.getDefaultState(), state -> check.matches(null, null, null, null, (IBlockState)state, '\u0000'));
        }
        PatchouliAPI.instance.registerMultiblock(name, PatchouliAPI.instance.makeMultiblock(pattern, rawMatchers));
    }

    public static <T> T getRecipe(Map<ResourceLocation, T> recipes, String name) {
        ResourceLocation res = new ResourceLocation(name);
        T recipe = recipes.get(res);
        if (recipe == null) {
            recipe = recipes.get(new ResourceLocation("crafttweaker", res.func_110623_a()));
        }
        return recipe;
    }
}

