/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.misc;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.misc.IWorldData;
import de.ellpeck.naturesaura.blocks.tiles.ItemStackHandlerNA;
import de.ellpeck.naturesaura.blocks.tiles.TileEntitySpawnLamp;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;

public class WorldData
implements IWorldData {
    private final Map<String, ItemStackHandlerNA> enderStorages = new HashMap<String, ItemStackHandlerNA>();
    public final ListMultimap<ResourceLocation, Tuple<Vec3d, Integer>> effectPowders = ArrayListMultimap.create();
    public final Set<TileEntitySpawnLamp> spawnLamps = new HashSet<TileEntitySpawnLamp>();

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == NaturesAuraAPI.capWorldData;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == NaturesAuraAPI.capWorldData ? this : null);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList storages = new NBTTagList();
        for (Map.Entry<String, ItemStackHandlerNA> entry : this.enderStorages.entrySet()) {
            ItemStackHandlerNA handler = entry.getValue();
            if (Helper.isEmpty((IItemHandler)handler)) continue;
            NBTTagCompound storageComp = handler.serializeNBT();
            storageComp.func_74778_a("name", entry.getKey());
            storages.func_74742_a((NBTBase)storageComp);
        }
        compound.func_74782_a("storages", (NBTBase)storages);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.enderStorages.clear();
        NBTTagList storages = compound.func_150295_c("storages", 10);
        for (NBTBase base : storages) {
            NBTTagCompound storageComp = (NBTTagCompound)base;
            ItemStackHandlerNA storage = this.getEnderStorage(storageComp.func_74779_i("name"));
            storage.deserializeNBT(storageComp);
        }
    }

    public ItemStackHandlerNA getEnderStorage(String name) {
        return this.enderStorages.computeIfAbsent(name, n -> new ItemStackHandlerNA(27));
    }

    @Override
    public boolean isEnderStorageLocked(String name) {
        ItemStackHandlerNA handler = this.getEnderStorage(name);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b() || stack.func_77973_b() != ModItems.TOKEN_TERROR) continue;
            return true;
        }
        return false;
    }
}

