/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.packet;

import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableInt;

public class PacketAuraChunk
implements IMessage {
    private int chunkX;
    private int chunkZ;
    private Map<BlockPos, MutableInt> drainSpots;

    public PacketAuraChunk(int chunkX, int chunkZ, Map<BlockPos, MutableInt> drainSpots) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.drainSpots = drainSpots;
    }

    public PacketAuraChunk() {
    }

    public void fromBytes(ByteBuf buf) {
        this.chunkX = buf.readInt();
        this.chunkZ = buf.readInt();
        this.drainSpots = new HashMap<BlockPos, MutableInt>();
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            this.drainSpots.put(BlockPos.func_177969_a((long)buf.readLong()), new MutableInt(buf.readInt()));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.chunkX);
        buf.writeInt(this.chunkZ);
        buf.writeInt(this.drainSpots.size());
        for (Map.Entry<BlockPos, MutableInt> entry : this.drainSpots.entrySet()) {
            buf.writeLong(entry.getKey().func_177986_g());
            buf.writeInt(entry.getValue().intValue());
        }
    }

    public static class Handler
    implements IMessageHandler<PacketAuraChunk, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketAuraChunk message, MessageContext ctx) {
            NaturesAura.proxy.scheduleTask(() -> {
                Chunk chunk;
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                if (world != null && (chunk = world.func_72964_e(message.chunkX, message.chunkZ)).hasCapability(NaturesAuraAPI.capAuraChunk, null)) {
                    AuraChunk auraChunk = (AuraChunk)chunk.getCapability(NaturesAuraAPI.capAuraChunk, null);
                    auraChunk.setSpots(message.drainSpots);
                }
            });
            return null;
        }
    }
}

