/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.packet;

import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.api.multiblock.Matcher;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketParticles
implements IMessage {
    private float posX;
    private float posY;
    private float posZ;
    private int type;
    private int[] data;

    public PacketParticles(float posX, float posY, float posZ, int type, int ... data) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.type = type;
        this.data = data;
    }

    public PacketParticles() {
    }

    public void fromBytes(ByteBuf buf) {
        this.posX = buf.readFloat();
        this.posY = buf.readFloat();
        this.posZ = buf.readFloat();
        this.type = buf.readByte();
        this.data = new int[buf.readByte()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = buf.readInt();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.posX);
        buf.writeFloat(this.posY);
        buf.writeFloat(this.posZ);
        buf.writeByte(this.type);
        buf.writeByte(this.data.length);
        for (int i : this.data) {
            buf.writeInt(i);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketParticles, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketParticles message, MessageContext ctx) {
            NaturesAura.proxy.scheduleTask(() -> {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                if (world != null) {
                    switch (message.type) {
                        case 0: {
                            BlockPos pos = new BlockPos((double)message.posX, (double)message.posY, (double)message.posZ);
                            Multiblocks.TREE_RITUAL.forEach(pos, 'G', (arg_0, arg_1) -> Handler.lambda$null$0((World)world, arg_0, arg_1));
                            break;
                        }
                        case 1: {
                            for (int i = world.field_73012_v.nextInt(20) + 10; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.5f, message.posY + 0.9f, message.posZ + 0.5f, (float)world.field_73012_v.nextGaussian() * 0.04f, world.field_73012_v.nextFloat() * 0.04f, (float)world.field_73012_v.nextGaussian() * 0.04f, 9030711, 1.5f, 25, 0.0f, false, true);
                            }
                            break;
                        }
                        case 2: {
                            for (int i = world.field_73012_v.nextInt(5) + 3; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + world.field_73012_v.nextFloat(), message.posY + world.field_73012_v.nextFloat(), message.posZ + world.field_73012_v.nextFloat(), 0.0, 0.0, 0.0, 0x33FF33, 1.0f, 50, 0.0f, false, true);
                            }
                            break;
                        }
                        case 3: {
                            for (int i = world.field_73012_v.nextInt(10) + 10; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY, message.posZ, world.field_73012_v.nextGaussian() * (double)0.1f, world.field_73012_v.nextGaussian() * (double)0.1f, world.field_73012_v.nextGaussian() * (double)0.1f, 9030711, 2.0f, 100, 0.0f, true, true);
                            }
                            break;
                        }
                        case 4: {
                            for (int i = world.field_73012_v.nextInt(5) + 2; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.25f + world.field_73012_v.nextFloat() * 0.5f, message.posY + 0.9f + 0.25f * world.field_73012_v.nextFloat(), message.posZ + 0.25f + world.field_73012_v.nextFloat() * 0.5f, world.field_73012_v.nextGaussian() * (double)0.02f, world.field_73012_v.nextFloat() * 0.02f, world.field_73012_v.nextGaussian() * (double)0.02f, 65280, world.field_73012_v.nextFloat() * 1.5f + 0.75f, 20, 0.0f, false, true);
                            }
                            break;
                        }
                        case 5: {
                            int color = message.data[0];
                            boolean releaseAura = message.data[1] > 0;
                            for (int i = world.field_73012_v.nextInt(5) + 5; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + world.field_73012_v.nextFloat(), message.posY + 1.1f, message.posZ + world.field_73012_v.nextFloat(), world.field_73012_v.nextGaussian() * (double)0.01f, world.field_73012_v.nextFloat() * 0.1f, world.field_73012_v.nextGaussian() * (double)0.01f, color, 2.0f + world.field_73012_v.nextFloat(), 40, 0.0f, true, true);
                                if (!releaseAura) continue;
                                for (int x = -1; x <= 1; x += 2) {
                                    for (int z = -1; z <= 1; z += 2) {
                                        NaturesAuraAPI.instance().spawnMagicParticle(message.posX + (float)(x * 3) + 0.5f, (double)message.posY + 2.5, message.posZ + (float)(z * 3) + 0.5f, world.field_73012_v.nextGaussian() * (double)0.02f, world.field_73012_v.nextFloat() * 0.04f, world.field_73012_v.nextGaussian() * (double)0.02f, 14038028, 1.0f + world.field_73012_v.nextFloat() * 2.0f, 75, 0.0f, true, true);
                                    }
                                }
                            }
                            break;
                        }
                        case 6: {
                            for (int i = world.field_73012_v.nextInt(20) + 15; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + world.field_73012_v.nextFloat(), message.posY + 0.25f + world.field_73012_v.nextFloat() * 0.5f, message.posZ + world.field_73012_v.nextFloat(), 0.0, world.field_73012_v.nextFloat() * 0.02f, 0.0, 6081584, 1.0f + world.field_73012_v.nextFloat() * 2.0f, 50, 0.0f, false, true);
                            }
                            break;
                        }
                        case 7: {
                            int color = message.data[0];
                            for (int i = world.field_73012_v.nextInt(10) + 10; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.25f + world.field_73012_v.nextFloat() * 0.5f, message.posY + 0.25f + world.field_73012_v.nextFloat() * 0.5f, message.posZ + 0.25f + world.field_73012_v.nextFloat() * 0.5f, world.field_73012_v.nextGaussian() * (double)0.02f, world.field_73012_v.nextGaussian() * (double)0.02f, world.field_73012_v.nextGaussian() * (double)0.02f, color, world.field_73012_v.nextFloat() * 2.0f + 1.0f, 25, 0.0f, false, true);
                            }
                            break;
                        }
                        case 8: {
                            for (int i = world.field_73012_v.nextInt(10) + 5; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.25f + world.field_73012_v.nextFloat() * 0.5f, message.posY + 1.01f, message.posZ + 0.25f + world.field_73012_v.nextFloat() * 0.5f, world.field_73012_v.nextGaussian() * (double)0.01f, world.field_73012_v.nextFloat() * 0.04f + 0.02f, world.field_73012_v.nextGaussian() * (double)0.01f, 6081584, 1.0f + world.field_73012_v.nextFloat() * 1.5f, 40, 0.0f, false, true);
                            }
                            break;
                        }
                        case 9: {
                            for (int i = world.field_73012_v.nextInt(20) + 20; i >= 0; --i) {
                                float x;
                                boolean side = world.field_73012_v.nextBoolean();
                                float f = side ? world.field_73012_v.nextFloat() : (x = world.field_73012_v.nextBoolean() ? 1.1f : -0.1f);
                                float z = !side ? world.field_73012_v.nextFloat() : (world.field_73012_v.nextBoolean() ? 1.1f : -0.1f);
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + x, message.posY + 0.1f + world.field_73012_v.nextFloat() * 0.98f, message.posZ + z, 0.0, 0.0, 0.0, 11369015, world.field_73012_v.nextFloat() + 1.0f, 50, 0.0f, true, true);
                            }
                            break;
                        }
                        case 10: {
                            for (int i = world.field_73012_v.nextInt(20) + 10; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY + 0.45f, message.posZ, world.field_73012_v.nextGaussian() * (double)0.015f, world.field_73012_v.nextGaussian() * (double)0.015f, world.field_73012_v.nextGaussian() * (double)0.015f, 14542847, world.field_73012_v.nextFloat() + 1.0f, 30, -0.06f, true, true);
                            }
                            break;
                        }
                        case 11: {
                            for (int i = 0; i < 360; i += 2) {
                                double rad = Math.toRadians(i);
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY + 0.01f, message.posZ, (float)Math.sin(rad) * 0.65f, 0.0, (float)Math.cos(rad) * 0.65f, 9509639, 3.0f, 10, 0.0f, false, true);
                            }
                            break;
                        }
                        case 12: {
                            int i;
                            int sapX = message.data[0];
                            int sapY = message.data[1];
                            int sapZ = message.data[2];
                            boolean releaseAura = message.data[3] > 0;
                            for (i = world.field_73012_v.nextInt(20) + 10; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnParticleStream((float)sapX + 0.5f + (float)world.field_73012_v.nextGaussian() * 3.0f, (float)sapY + 0.5f + world.field_73012_v.nextFloat() * 4.0f, (float)sapZ + 0.5f + (float)world.field_73012_v.nextGaussian() * 3.0f, message.posX + 0.5f, message.posY + 0.5f, message.posZ + 0.5f, 0.6f, BiomeColorHelper.func_180287_b((IBlockAccess)world, (BlockPos)new BlockPos(sapX, sapY, sapZ)), 1.5f);
                            }
                            if (!releaseAura) break;
                            for (i = world.field_73012_v.nextInt(10) + 10; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.25f + world.field_73012_v.nextFloat() * 0.5f, message.posY + 1.01f, message.posZ + 0.25f + world.field_73012_v.nextFloat() * 0.5f, world.field_73012_v.nextGaussian() * (double)0.03f, world.field_73012_v.nextFloat() * 0.04f + 0.04f, world.field_73012_v.nextGaussian() * (double)0.03f, 6081584, 1.0f + world.field_73012_v.nextFloat() * 1.5f, 60, 0.0f, false, true);
                            }
                            break;
                        }
                        case 13: {
                            int i;
                            int genX = message.data[0];
                            int genY = message.data[1];
                            int genZ = message.data[2];
                            for (i = world.field_73012_v.nextInt(20) + 10; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY + 0.5f, message.posZ, world.field_73012_v.nextGaussian() * (double)0.02f, world.field_73012_v.nextFloat() * 0.25f, world.field_73012_v.nextGaussian() * (double)0.02f, 0xFFADFD, 1.5f, 40, 0.0f, false, true);
                            }
                            for (i = world.field_73012_v.nextInt(50) + 30; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle((double)((float)genX + 0.5f) + world.field_73012_v.nextGaussian() * 2.5, (float)genY + 0.1f, (double)((float)genZ + 0.5f) + world.field_73012_v.nextGaussian() * 2.5, world.field_73012_v.nextGaussian() * (double)0.01f, world.field_73012_v.nextFloat() * 0.01f, world.field_73012_v.nextGaussian() * (double)0.01f, 13886719, 1.5f, 150, 0.0f, false, true);
                            }
                            break;
                        }
                        case 14: {
                            NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY + 0.4f, message.posZ, world.field_73012_v.nextGaussian() * (double)0.005f, world.field_73012_v.nextFloat() * 0.005f, world.field_73012_v.nextGaussian() * (double)0.005f, 13381910, 1.5f, 40, 0.0f, false, true);
                            break;
                        }
                        case 15: {
                            for (int i = world.field_73012_v.nextInt(5) + 5; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.3f + world.field_73012_v.nextFloat() * 0.4f, message.posY + 0.15f + world.field_73012_v.nextFloat() * 0.5f, message.posZ + 0.3f + world.field_73012_v.nextFloat() * 0.4f, 0.0, 0.0, 0.0, 16032066, 1.0f, 30, 0.0f, false, true);
                            }
                            break;
                        }
                        case 16: {
                            for (int i = world.field_73012_v.nextInt(5) + 5; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.25f + world.field_73012_v.nextFloat() * 0.5f, message.posY + 1.01f, message.posZ + 0.25f + world.field_73012_v.nextFloat() * 0.5f, world.field_73012_v.nextGaussian() * (double)0.01f, world.field_73012_v.nextFloat() * 0.04f + 0.02f, world.field_73012_v.nextGaussian() * (double)0.01f, 13710088, 1.0f + world.field_73012_v.nextFloat() * 1.5f, 40, 0.0f, false, true);
                            }
                            break;
                        }
                        case 17: {
                            int i;
                            boolean child = message.data[0] > 0;
                            float height = (float)message.data[1] / 10.0f;
                            int genX = message.data[2];
                            int genY = message.data[3];
                            int genZ = message.data[4];
                            int n = i = child ? world.field_73012_v.nextInt(10) + 10 : world.field_73012_v.nextInt(20) + 20;
                            while (i >= 0) {
                                NaturesAuraAPI.instance().spawnMagicParticle((double)message.posX + world.field_73012_v.nextGaussian() * 0.25, (double)(message.posY + height * 0.75f) + world.field_73012_v.nextGaussian() * 0.25, (double)message.posZ + world.field_73012_v.nextGaussian() * 0.25, world.field_73012_v.nextGaussian() * (double)0.01f, world.field_73012_v.nextFloat() * 0.01f, world.field_73012_v.nextGaussian() * (double)0.01f, 4388040, world.field_73012_v.nextFloat() * (child ? 0.5f : 2.0f) + 1.0f, world.field_73012_v.nextInt(30) + 40, 0.0f, true, true);
                                --i;
                            }
                            NaturesAuraAPI.instance().spawnParticleStream(message.posX, message.posY + height * 0.75f, message.posZ, (float)genX + 0.5f, (float)genY + 0.5f, (float)genZ + 0.5f, 0.15f, 4310260, child ? 1.5f : 3.0f);
                            break;
                        }
                        case 18: {
                            int color = message.data[0];
                            for (int i = world.field_73012_v.nextInt(10) + 20; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + world.field_73012_v.nextFloat(), message.posY + world.field_73012_v.nextFloat(), message.posZ + world.field_73012_v.nextFloat(), world.field_73012_v.nextGaussian() * (double)0.01f, world.field_73012_v.nextFloat() * 0.01f, world.field_73012_v.nextGaussian() * (double)0.01f, color, 1.5f, 80, 0.0f, true, true);
                            }
                            break;
                        }
                        case 19: {
                            for (int i = world.field_73012_v.nextInt(20) + 10; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY + 0.5f, message.posZ, world.field_73012_v.nextGaussian() * (double)0.02f, world.field_73012_v.nextFloat() * 0.02f, world.field_73012_v.nextGaussian() * (double)0.02f, 1488818, 1.5f, 40, 0.0f, false, true);
                            }
                            break;
                        }
                        case 20: {
                            for (int i = world.field_73012_v.nextInt(5) + 2; i >= 0; --i) {
                                Multiblocks.RF_CONVERTER.forEach(new BlockPos((double)message.posX, (double)message.posY, (double)message.posZ), 'R', (arg_0, arg_1) -> Handler.lambda$null$1((World)world, message, arg_0, arg_1));
                            }
                            break;
                        }
                        case 21: {
                            int color = message.data[0];
                            for (int i = world.field_73012_v.nextInt(20) + 10; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY + 0.5f, message.posZ, world.field_73012_v.nextGaussian() * (double)0.01f, world.field_73012_v.nextFloat() * 0.01f, world.field_73012_v.nextGaussian() * (double)0.01f, color, 1.5f, 40, 0.0f, false, true);
                            }
                            break;
                        }
                        case 22: {
                            float motionX = (float)message.data[0] / 100.0f;
                            float motionY = (float)message.data[1] / 100.0f;
                            float motionZ = (float)message.data[2] / 100.0f;
                            for (int i = world.field_73012_v.nextInt(60) + 30; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle((double)message.posX + world.field_73012_v.nextGaussian() * 10.0, (double)message.posY + world.field_73012_v.nextGaussian() * 10.0, (double)message.posZ + world.field_73012_v.nextGaussian() * 10.0, motionX * 0.2f, motionY * 0.2f, motionZ * 0.2f, IAuraType.forWorld((World)world).getColor(), 2.0f, 30, 0.0f, false, true);
                            }
                            break;
                        }
                        case 23: {
                            int i;
                            for (i = world.field_73012_v.nextInt(30) + 30; i >= 0; --i) {
                                float y;
                                float x;
                                int side = world.field_73012_v.nextInt(3);
                                float f = side != 0 ? world.field_73012_v.nextFloat() : (x = world.field_73012_v.nextBoolean() ? 1.1f : -0.1f);
                                float f2 = side != 1 ? world.field_73012_v.nextFloat() : (y = world.field_73012_v.nextBoolean() ? 1.1f : -0.1f);
                                float z = side != 2 ? world.field_73012_v.nextFloat() : (world.field_73012_v.nextBoolean() ? 1.1f : -0.1f);
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + x, message.posY + y, message.posZ + z, 0.0, 0.0, 0.0, 1592333, world.field_73012_v.nextFloat() + 1.0f, 30, 0.0f, true, true);
                            }
                            for (i = world.field_73012_v.nextInt(20) + 10; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + world.field_73012_v.nextFloat(), message.posY + 1.0f, message.posZ + world.field_73012_v.nextFloat(), world.field_73012_v.nextGaussian() * (double)0.01f, world.field_73012_v.nextFloat() * 0.04f + 0.02f, world.field_73012_v.nextGaussian() * (double)0.01f, 6081584, 1.0f + world.field_73012_v.nextFloat() * 1.5f, 40, 0.0f, true, true);
                            }
                            break;
                        }
                        case 24: {
                            int goalX = message.data[0];
                            int goalY = message.data[1];
                            int goalZ = message.data[2];
                            NaturesAuraAPI.instance().setParticleSpawnRange(64);
                            for (int i = world.field_73012_v.nextInt(30) + 30; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnParticleStream(message.posX + (float)world.field_73012_v.nextGaussian(), message.posY + (float)world.field_73012_v.nextGaussian(), message.posZ + (float)world.field_73012_v.nextGaussian(), (float)goalX + 0.25f + world.field_73012_v.nextFloat() * 0.5f, (float)goalY + 0.25f + world.field_73012_v.nextFloat() * 0.5f, (float)goalZ + 0.25f + world.field_73012_v.nextFloat() * 0.5f, 0.65f, message.data[3 + world.field_73012_v.nextInt(message.data.length - 3)], 1.0f);
                            }
                            NaturesAuraAPI.instance().setParticleSpawnRange(32);
                            break;
                        }
                        case 25: {
                            float width = (float)message.data[0] / 100.0f;
                            float height = (float)message.data[1] / 100.0f;
                            float depth = (float)message.data[2] / 100.0f;
                            for (int i = world.field_73012_v.nextInt(100) + 50; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + world.field_73012_v.nextFloat() * width, message.posY + world.field_73012_v.nextFloat() * height, message.posZ + world.field_73012_v.nextFloat() * depth, 0.0, 0.0, 0.0, 14028031, 1.0f + world.field_73012_v.nextFloat(), 60, 0.0f, false, true);
                            }
                            break;
                        }
                        case 26: {
                            int i;
                            int x = message.data[0];
                            int y = message.data[1];
                            int z = message.data[2];
                            for (i = world.field_73012_v.nextInt(10) + 5; i >= 0; --i) {
                                NaturesAuraAPI.instance().spawnMagicParticle((float)x + 0.25f + world.field_73012_v.nextFloat() * 0.5f, (float)y + 1.01f, (float)z + 0.25f + world.field_73012_v.nextFloat() * 0.5f, world.field_73012_v.nextGaussian() * (double)0.01f, world.field_73012_v.nextFloat() * 0.04f + 0.02f, world.field_73012_v.nextGaussian() * (double)0.01f, 6081584, 1.0f + world.field_73012_v.nextFloat() * 1.5f, 40, 0.0f, false, true);
                            }
                            for (i = world.field_73012_v.nextInt(10) + 10; i >= 0; --i) {
                                world.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, (double)message.posX, (double)message.posY, (double)message.posZ, world.field_73012_v.nextGaussian() * (double)0.03f, world.field_73012_v.nextGaussian() * (double)0.03f, world.field_73012_v.nextGaussian() * (double)0.03f, new int[0]);
                            }
                            break;
                        }
                    }
                }
            });
            return null;
        }

        private static /* synthetic */ Boolean lambda$null$1(World world, PacketParticles message, BlockPos blockPos, Matcher matcher) {
            if (world.field_73012_v.nextFloat() < 0.35f) {
                NaturesAuraAPI.instance().spawnParticleStream((float)blockPos.func_177958_n() + world.field_73012_v.nextFloat(), (float)blockPos.func_177956_o() + world.field_73012_v.nextFloat(), (float)blockPos.func_177952_p() + world.field_73012_v.nextFloat(), message.posX + world.field_73012_v.nextFloat(), message.posY + world.field_73012_v.nextFloat(), message.posZ + world.field_73012_v.nextFloat(), 0.05f, 16718341, 1.5f);
            }
            return true;
        }

        private static /* synthetic */ Boolean lambda$null$0(World world, BlockPos dustPos, Matcher matcher) {
            IBlockState state = world.func_180495_p(dustPos);
            AxisAlignedBB box = state.func_185900_c((IBlockAccess)world, dustPos);
            NaturesAuraAPI.instance().spawnMagicParticle((double)dustPos.func_177958_n() + box.field_72340_a + (box.field_72336_d - box.field_72340_a) * (double)world.field_73012_v.nextFloat(), (float)dustPos.func_177956_o() + 0.1f, (double)dustPos.func_177952_p() + box.field_72339_c + (box.field_72334_f - box.field_72339_c) * (double)world.field_73012_v.nextFloat(), (float)world.field_73012_v.nextGaussian() * 0.02f, world.field_73012_v.nextFloat() * 0.01f + 0.02f, (float)world.field_73012_v.nextGaussian() * 0.02f, 16042818, 2.0f, 50, 0.0f, false, true);
            return true;
        }
    }
}

