/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.reg;

import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.reg.IColorProvidingBlock;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import de.ellpeck.naturesaura.reg.ICreativeItem;
import de.ellpeck.naturesaura.reg.ICustomItemBlockProvider;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.IModelProvider;
import de.ellpeck.naturesaura.reg.ITESRProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ModRegistry {
    private static final List<IModItem> ALL_ITEMS = new ArrayList<IModItem>();

    public static void add(IModItem item) {
        ALL_ITEMS.add(item);
    }

    private static void registerPotion(Potion potion, String name) {
        potion.func_76390_b("potion.naturesaura." + name + ".name");
        potion.setRegistryName("naturesaura", name);
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)potion);
    }

    private static void registerItem(Item item, String name, CreativeTabs tab) {
        item.func_77655_b("naturesaura." + name);
        item.setRegistryName("naturesaura", name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        item.func_77637_a(tab);
    }

    private static void registerBlock(Block block, String name, ItemBlock item, CreativeTabs tab) {
        block.func_149663_c("naturesaura." + name);
        block.setRegistryName("naturesaura", name);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        if (item != null) {
            item.setRegistryName(block.getRegistryName());
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        }
        block.func_149647_a(tab);
    }

    private static CreativeTabs getTab(IModItem item) {
        if (item instanceof ICreativeItem) {
            return ((ICreativeItem)((Object)item)).getTabToAdd();
        }
        return null;
    }

    public static void preInit(FMLPreInitializationEvent event) {
        for (IModItem item : ALL_ITEMS) {
            if (item instanceof Item) {
                ModRegistry.registerItem((Item)item, item.getBaseName(), ModRegistry.getTab(item));
            } else if (item instanceof Block) {
                Block block = (Block)item;
                ItemBlock itemBlock = item instanceof ICustomItemBlockProvider ? ((ICustomItemBlockProvider)((Object)item)).getItemBlock() : new ItemBlock(block);
                ModRegistry.registerBlock(block, item.getBaseName(), itemBlock, ModRegistry.getTab(item));
            } else if (item instanceof Potion) {
                ModRegistry.registerPotion((Potion)item, item.getBaseName());
            }
            if (item instanceof IModelProvider) {
                Map<ItemStack, ModelResourceLocation> models = ((IModelProvider)((Object)item)).getModelLocations();
                for (ItemStack stack : models.keySet()) {
                    NaturesAura.proxy.registerRenderer(stack, models.get(stack));
                }
            }
            item.onPreInit(event);
        }
    }

    public static void init(FMLInitializationEvent event) {
        for (IModItem item : ALL_ITEMS) {
            if (item instanceof IColorProvidingBlock) {
                NaturesAura.proxy.addColorProvidingBlock((IColorProvidingBlock)((Object)item));
            }
            if (item instanceof IColorProvidingItem) {
                NaturesAura.proxy.addColorProvidingItem((IColorProvidingItem)((Object)item));
            }
            if (item instanceof ITESRProvider) {
                NaturesAura.proxy.registerTESR((ITESRProvider)((Object)item));
            }
            item.onInit(event);
        }
    }

    public static void postInit(FMLPostInitializationEvent event) {
        for (IModItem item : ALL_ITEMS) {
            item.onPostInit(event);
        }
    }
}

