/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.smart;

import blusunrize.immersiveengineering.client.models.ModelData;
import blusunrize.immersiveengineering.client.models.multilayer.MultiLayerModel;
import blusunrize.immersiveengineering.client.models.smart.ConnModelReal;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;

public class ConnLoader
implements ICustomModelLoader {
    public static final String RESOURCE_LOCATION = "models/block/smartmodel/conn_";
    public static final ResourceLocation DATA_BASED_LOC = new ResourceLocation("immersiveengineering", "models/block/smartmodel/connector");
    public static final ImmutableSet<BlockRenderLayer> ALL_LAYERS = ImmutableSet.copyOf((Object[])BlockRenderLayer.values());
    public static Map<String, ImmutableMap<String, String>> textureReplacements = new HashMap<String, ImmutableMap<String, String>>();
    public static Map<String, ResourceLocation> baseModels = new HashMap<String, ResourceLocation>();

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        ConnModelReal.cache.invalidateAll();
    }

    public boolean accepts(@Nonnull ResourceLocation modelLocation) {
        return modelLocation.equals((Object)DATA_BASED_LOC) || modelLocation.func_110623_a().contains(RESOURCE_LOCATION);
    }

    @Nonnull
    public IModel loadModel(@Nonnull ResourceLocation modelLocation) {
        String name;
        ResourceLocation r;
        if (modelLocation.equals((Object)DATA_BASED_LOC)) {
            return new ConnModelBase();
        }
        String resourcePath = modelLocation.func_110623_a();
        int pos = resourcePath.indexOf("conn_");
        if (pos >= 0 && (r = baseModels.get(name = resourcePath.substring(pos += 5))) != null) {
            ImmutableMap<String, String> texRepl = ImmutableMap.of();
            if (textureReplacements.containsKey(name)) {
                texRepl = textureReplacements.get(name);
            }
            return new ConnModelBase(r, texRepl, (ImmutableMap<String, String>)ImmutableMap.of((Object)"flip-v", (Object)"true"), ALL_LAYERS);
        }
        return ModelLoaderRegistry.getMissingModel();
    }

    private static class ConnModelBase
    implements IModel {
        private static final ResourceLocation WIRE_LOC = new ResourceLocation("immersiveengineering".toLowerCase(Locale.ENGLISH) + ":blocks/wire");
        @Nullable
        private final ModelData baseData;
        @Nonnull
        private final ImmutableSet<BlockRenderLayer> layers;
        @Nonnull
        private final ImmutableMap<String, String> externalTextures;
        private static final ImmutableSet<String> ownKeys = ImmutableSet.of((Object)"base", (Object)"custom", (Object)"textures", (Object)"layers");

        public ConnModelBase(@Nonnull ResourceLocation b, @Nonnull ImmutableMap<String, String> t, @Nonnull ImmutableMap<String, String> customBase, @Nonnull ImmutableSet<BlockRenderLayer> layers) {
            this(new ModelData(b, ModelData.asJsonObject(customBase), t), layers, (ImmutableMap<String, String>)ImmutableMap.of());
        }

        public ConnModelBase(@Nonnull ResourceLocation b) {
            this(b, (ImmutableMap<String, String>)ImmutableMap.of(), (ImmutableMap<String, String>)ImmutableMap.of(), ALL_LAYERS);
        }

        public ConnModelBase() {
            this.baseData = null;
            this.layers = ALL_LAYERS;
            this.externalTextures = ImmutableMap.of();
        }

        public ConnModelBase(@Nullable ModelData newData, @Nonnull ImmutableSet<BlockRenderLayer> layers, @Nonnull ImmutableMap<String, String> externalTextures) {
            this.baseData = newData;
            this.layers = layers;
            this.externalTextures = externalTextures;
        }

        @Nonnull
        public Collection<ResourceLocation> getDependencies() {
            if (this.baseData == null) {
                return ImmutableList.of();
            }
            this.baseData.attemptToLoad(false);
            if (this.baseData.getModel() != null) {
                ArrayList<ResourceLocation> ret = new ArrayList<ResourceLocation>(this.baseData.getModel().getDependencies());
                ret.add(0, this.baseData.location);
                return ret;
            }
            return ImmutableList.of((Object)this.baseData.location);
        }

        @Nonnull
        public Collection<ResourceLocation> getTextures() {
            if (this.baseData == null) {
                return ImmutableList.of();
            }
            this.baseData.attemptToLoad(false);
            if (this.baseData.getModel() != null) {
                ArrayList<ResourceLocation> ret = new ArrayList<ResourceLocation>(this.baseData.getModel().getTextures());
                ret.add(WIRE_LOC);
                return ret;
            }
            return ImmutableList.of((Object)WIRE_LOC);
        }

        @Nonnull
        public IBakedModel bake(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            assert (this.baseData != null);
            this.baseData.attemptToLoad(true);
            assert (this.baseData.getModel() != null);
            return new ConnModelReal(this.baseData.getModel().bake(state, format, bakedTextureGetter), this.layers);
        }

        @Nonnull
        public IModel process(ImmutableMap<String, String> customData) {
            if (customData == null || customData.isEmpty() || !customData.containsKey((Object)"base")) {
                return this;
            }
            JsonObject obj = ModelData.asJsonObject(customData);
            ModelData newData = ModelData.fromJson(obj, ownKeys, "base", this.externalTextures);
            Object layers = ALL_LAYERS;
            if (obj.has("layers") && obj.get("layers").isJsonArray()) {
                JsonArray arr = obj.get("layers").getAsJsonArray();
                layers = new ArrayList(arr.size());
                for (JsonElement ele : arr) {
                    if (ele.isJsonPrimitive() && ele.getAsJsonPrimitive().isString()) {
                        String layerAsStr = ele.getAsString();
                        if (MultiLayerModel.LAYERS_BY_NAME.containsKey(layerAsStr)) {
                            layers.add(MultiLayerModel.LAYERS_BY_NAME.get(layerAsStr));
                            continue;
                        }
                        throw new RuntimeException("Invalid layer \"" + layerAsStr + "\" in wire model");
                    }
                    throw new RuntimeException("Layers in wire models must be strings! Invalid value: " + ele.toString());
                }
            }
            layers = ImmutableSet.copyOf(layers);
            if (!newData.equals(this.baseData) || !layers.equals(this.layers)) {
                return new ConnModelBase(newData, (ImmutableSet<BlockRenderLayer>)layers, this.externalTextures);
            }
            return this;
        }

        @Nonnull
        public IModel retexture(ImmutableMap<String, String> textures) {
            if (this.baseData != null) {
                if (!(textures.equals(this.baseData.textures) || textures.isEmpty() && !this.baseData.textures.isEmpty())) {
                    return new ConnModelBase(new ModelData(this.baseData.location, this.baseData.data, textures), this.layers, textures);
                }
            } else if (!this.externalTextures.equals(textures)) {
                return new ConnModelBase(null, this.layers, textures);
            }
            return this;
        }
    }
}

