/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class BakedModelTransformer {
    static Field f_unpackedData;

    public static IBakedModel transform(IBakedModel model, IVertexTransformer transformer, IBlockState state, long rand) {
        return BakedModelTransformer.transform(model, transformer, state, rand, f -> f);
    }

    public static IBakedModel transform(IBakedModel model, IVertexTransformer transformer, IBlockState state, long rand, Function<VertexFormat, VertexFormat> formatRemapper) {
        List[] quads = new List[7];
        for (int i = 0; i < quads.length; ++i) {
            quads[i] = new ArrayList();
            for (BakedQuad quad : model.func_188616_a(state, i == 6 ? null : EnumFacing.func_82600_a((int)i), rand)) {
                quads[i].add(BakedModelTransformer.transform(quad, transformer, formatRemapper));
            }
        }
        return new TransformedModel(model, quads);
    }

    private static BakedQuad transform(BakedQuad quad, IVertexTransformer transformer, Function<VertexFormat, VertexFormat> formatRemapper) {
        VertexFormat format = quad.getFormat();
        VertexFormat newFormat = formatRemapper.apply(format);
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(newFormat);
        if (quad.func_178212_b()) {
            builder.setQuadTint(quad.func_178211_c());
        }
        builder.setQuadOrientation(quad.func_178210_d());
        LightUtil.putBakedQuad((IVertexConsumer)builder, (BakedQuad)quad);
        UnpackedBakedQuad unpackedQuad = builder.build();
        try {
            float[][][] unpackedData = BakedModelTransformer.getUnpackedData(unpackedQuad);
            int count = newFormat.func_177345_h();
            for (int v = 0; v < 4; ++v) {
                for (int e = 0; e < count; ++e) {
                    VertexFormatElement element = newFormat.func_177348_c(e);
                    unpackedData[v][e] = transformer.transform(quad, element.func_177367_b(), element.func_177375_c(), unpackedData[v][e]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return unpackedQuad;
    }

    static float[][][] getUnpackedData(UnpackedBakedQuad unpackedQuad) throws Exception {
        if (f_unpackedData == null) {
            f_unpackedData = ReflectionHelper.findField(UnpackedBakedQuad.class, (String[])new String[]{"unpackedData"});
            f_unpackedData.setAccessible(true);
        }
        return (float[][][])f_unpackedData.get(unpackedQuad);
    }

    public static interface IVertexTransformer {
        public float[] transform(BakedQuad var1, VertexFormatElement.EnumType var2, VertexFormatElement.EnumUsage var3, float ... var4);
    }

    private static final class TransformedModel
    implements IBakedModel {
        private final IBakedModel parent;
        private final List<BakedQuad>[] quads;

        public TransformedModel(IBakedModel parent, List<BakedQuad>[] quads) {
            this.parent = parent;
            this.quads = quads;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            return this.quads[side == null ? 6 : side.ordinal()];
        }

        public boolean func_177555_b() {
            return this.parent.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.parent.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.parent.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.parent.func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return this.parent.func_177552_f();
        }

        public ItemOverrideList func_188617_f() {
            return this.parent.func_188617_f();
        }
    }
}

