/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.achievement.criteria;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class BlockActivatedTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("lootgames", "activate_block");
    private final Map<PlayerAdvancements, Listeners> listeners = new HashMap<PlayerAdvancements, Listeners>();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancementsIn);
        if (listeners == null) {
            listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, listeners);
        }
        listeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancementsIn);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        Block block = null;
        if (json.has("block")) {
            ResourceLocation rl = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"block"));
            if (!Block.field_149771_c.func_148741_d((Object)rl)) {
                throw new JsonSyntaxException("Unknown block type '" + rl + "'");
            }
            block = (Block)Block.field_149771_c.func_82594_a((Object)rl);
        }
        HashMap map = null;
        if (json.has("state")) {
            if (block == null) {
                throw new JsonSyntaxException("Can't define block state without a specific block type");
            }
            BlockStateContainer blockstatecontainer = block.func_176194_O();
            for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"state").entrySet()) {
                IProperty iproperty = blockstatecontainer.func_185920_a((String)entry.getKey());
                if (iproperty == null) {
                    throw new JsonSyntaxException("Unknown block state property '" + (String)entry.getKey() + "' for block '" + Block.field_149771_c.func_177774_c((Object)block) + "'");
                }
                String s = JsonUtils.func_151206_a((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                Optional optional = iproperty.func_185929_b(s);
                if (!optional.isPresent()) {
                    throw new JsonSyntaxException("Invalid block state value '" + s + "' for property '" + (String)entry.getKey() + "' on block '" + Block.field_149771_c.func_177774_c((Object)block) + "'");
                }
                if (map == null) {
                    map = Maps.newHashMap();
                }
                map.put(iproperty, optional.get());
            }
        }
        LocationPredicate locationpredicate = LocationPredicate.func_193454_a((JsonElement)json.get("location"));
        ItemPredicate itempredicate = ItemPredicate.func_192492_a((JsonElement)json.get("item"));
        return new Instance(block, map, locationpredicate, itempredicate);
    }

    public void trigger(EntityPlayerMP player, BlockPos pos, ItemStack item) {
        IBlockState iblockstate = player.field_70170_p.func_180495_p(pos);
        Listeners listeners = this.listeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(iblockstate, pos, player.func_71121_q(), item);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = new HashSet<ICriterionTrigger.Listener<Instance>>();

        Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        void trigger(IBlockState state, BlockPos pos, WorldServer world, ItemStack item) {
            ArrayList<ICriterionTrigger.Listener<Instance>> list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(state, pos, world, item)) continue;
                if (list == null) {
                    list = new ArrayList<ICriterionTrigger.Listener<Instance>>();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener : list) {
                    listener.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final Block block;
        private final Map<IProperty<?>, Object> properties;
        private final LocationPredicate location;
        private final ItemPredicate item;

        Instance(@Nullable Block block, @Nullable Map<IProperty<?>, Object> propertiesIn, LocationPredicate locationIn, ItemPredicate itemIn) {
            super(ID);
            this.block = block;
            this.properties = propertiesIn;
            this.location = locationIn;
            this.item = itemIn;
        }

        boolean test(IBlockState state, BlockPos pos, WorldServer world, ItemStack item) {
            if (this.block != null && state.func_177230_c() != this.block) {
                return false;
            }
            if (this.properties != null) {
                for (Map.Entry<IProperty<?>, Object> entry : this.properties.entrySet()) {
                    if (state.func_177229_b(entry.getKey()) == entry.getValue()) continue;
                    return false;
                }
            }
            if (!this.location.func_193453_a(world, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p())) {
                return false;
            }
            return this.item.func_192493_a(item);
        }
    }
}

