/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.api.minigame;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;
import ru.timeconqueror.lootgames.achievement.AdvancementManager;
import ru.timeconqueror.lootgames.api.packet.SMessageGameUpdate;
import ru.timeconqueror.lootgames.api.task.TEPostponeTaskScheduler;
import ru.timeconqueror.lootgames.api.tileentity.TileEntityGameMaster;
import ru.timeconqueror.lootgames.packets.NetworkHandler;
import ru.timeconqueror.lootgames.world.gen.DungeonGenerator;
import ru.timeconqueror.timecore.api.auxiliary.NetworkUtils;

public abstract class LootGame {
    protected TileEntityGameMaster<?> masterTileEntity;
    protected TEPostponeTaskScheduler serverTaskPostponer;
    private Runnable winCallback;
    private Runnable loseCallback;
    private Runnable endGameCallback;

    public void setMasterTileEntity(TileEntityGameMaster<?> masterTileEntity) {
        this.masterTileEntity = masterTileEntity;
    }

    public void init() {
        this.serverTaskPostponer = new TEPostponeTaskScheduler(this.masterTileEntity);
    }

    public void onTick() {
        if (this.isServerSide()) {
            this.serverTaskPostponer.onUpdate();
        }
    }

    public boolean isServerSide() {
        return !this.masterTileEntity.func_145831_w().field_72995_K;
    }

    public World getWorld() {
        return this.masterTileEntity.func_145831_w();
    }

    public BlockPos getMasterPos() {
        return this.masterTileEntity.func_174877_v();
    }

    protected final void winGame() {
        this.onGameEnded();
        if (this.winCallback != null) {
            this.winCallback.run();
        }
        for (EntityPlayerMP entityPlayerMP : NetworkUtils.getPlayersNearby((BlockPos)this.getCentralRoomPos(), (double)this.getDefaultBroadcastDistance())) {
            AdvancementManager.WIN_GAME.trigger(entityPlayerMP, "win");
        }
    }

    protected abstract BlockPos getCentralRoomPos();

    protected final void loseGame() {
        this.onGameEnded();
        if (this.loseCallback != null) {
            this.loseCallback.run();
        }
        for (EntityPlayerMP entityPlayerMP : NetworkUtils.getPlayersNearby((BlockPos)this.getCentralRoomPos(), (double)this.getDefaultBroadcastDistance())) {
            AdvancementManager.WIN_GAME.trigger(entityPlayerMP, "lose");
        }
    }

    private void onGameEnded() {
        if (this.endGameCallback != null) {
            this.endGameCallback.run();
        }
        DungeonGenerator.resetUnbreakablePlayfield(this.getWorld(), this.getRoomFloorPos());
        this.masterTileEntity.destroyGameBlocks();
    }

    public int getDefaultBroadcastDistance() {
        return 17;
    }

    protected abstract BlockPos getRoomFloorPos();

    public void setOnWin(Runnable onWin) {
        this.winCallback = onWin;
    }

    public void setOnLose(Runnable onLose) {
        this.loseCallback = onLose;
    }

    public void setOnGameEnded(Runnable onEnd) {
        this.endGameCallback = onEnd;
    }

    public void saveDataAndSendToClient() {
        this.masterTileEntity.setBlockToUpdateAndSave();
    }

    public void saveData() {
        this.masterTileEntity.func_70296_d();
    }

    public NBTTagCompound writeNBTForSaving() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeCommonNBT(nbt);
        nbt.func_74782_a("task_scheduler", (NBTBase)this.serverTaskPostponer.serializeNBT());
        return nbt;
    }

    public void readNBTFromSave(NBTTagCompound compound) {
        this.readCommonNBT(compound);
        this.serverTaskPostponer.deserializeNBT((NBTTagList)compound.func_74781_a("task_scheduler"));
    }

    public NBTTagCompound writeNBTForClient() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeCommonNBT(nbt);
        return nbt;
    }

    public void sendUpdatePacket(String key, NBTTagCompound compoundToSend) {
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.getWorld().field_73011_w.getDimension(), (double)this.masterTileEntity.func_174877_v().func_177958_n(), (double)this.masterTileEntity.func_174877_v().func_177956_o(), (double)this.masterTileEntity.func_174877_v().func_177952_p(), -1.0);
        NetworkHandler.INSTANCE.sendToAllTracking((IMessage)new SMessageGameUpdate(this.masterTileEntity.func_174877_v(), key, compoundToSend), point);
    }

    @SideOnly(value=Side.CLIENT)
    public void onUpdatePacket(String key, @Nullable NBTTagCompound compoundIn) {
    }

    @SideOnly(value=Side.CLIENT)
    public void readNBTFromClient(NBTTagCompound compound) {
        this.readCommonNBT(compound);
    }

    public void writeCommonNBT(NBTTagCompound compound) {
    }

    public void readCommonNBT(NBTTagCompound compound) {
    }
}

