/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.api.packet;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.lootgames.api.minigame.LootGame;
import ru.timeconqueror.lootgames.api.tileentity.TileEntityGameMaster;
import ru.timeconqueror.lootgames.minigame.minesweeper.tileentity.TileEntityMSMaster;

public class SMessageGameUpdate
implements IMessage {
    private BlockPos pos;
    private NBTTagCompound compound;
    private String key;

    @ApiStatus.Internal
    public SMessageGameUpdate() {
    }

    public SMessageGameUpdate(BlockPos masterPos, String key, @Nullable NBTTagCompound compound) {
        this.pos = masterPos;
        this.compound = compound;
        this.key = key;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer buff = new PacketBuffer(buf);
        this.pos = buff.func_179259_c();
        try {
            this.compound = buff.func_150793_b();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.key = ByteBufUtils.readUTF8String((ByteBuf)buff);
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer buff = new PacketBuffer(buf);
        buff.func_179255_a(this.pos);
        buff.func_150786_a(this.compound == null ? new NBTTagCompound() : this.compound);
        ByteBufUtils.writeUTF8String((ByteBuf)buff, (String)this.key);
    }

    public static class Handler
    implements IMessageHandler<SMessageGameUpdate, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(SMessageGameUpdate msg, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                TileEntity te = world.func_175625_s(msg.pos);
                if (te instanceof TileEntityGameMaster) {
                    TileEntityMSMaster master = (TileEntityMSMaster)te;
                    ((LootGame)master.getGame()).onUpdatePacket(msg.key, msg.compound);
                } else {
                    LootGames.logHelper.error("Something went wrong. Can't find TileEntityMaster on pos: {}", new Object[]{msg.pos});
                }
            });
            return null;
        }
    }
}

