/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.api.util;

import java.lang.reflect.Array;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class NBTUtils {
    public static <NBT extends NBTBase, T extends INBTSerializable<NBT>> T[][] readTwoDimArrFromNBT(NBTTagCompound tableTag, Class<T> elementClass, Supplier<T> defaultElementCreator) {
        int size = tableTag.func_74762_e("size");
        INBTSerializable[][] table = null;
        for (int i = 0; i < size; ++i) {
            NBTTagCompound columnTag = tableTag.func_74775_l(Integer.toString(i));
            int columnSize = columnTag.func_74762_e("size");
            INBTSerializable[] column = (INBTSerializable[])Array.newInstance(elementClass, columnSize);
            for (int j = 0; j < columnSize; ++j) {
                if (!columnTag.func_74764_b(Integer.toString(j))) continue;
                NBTBase elementTag = columnTag.func_74781_a(Integer.toString(j));
                INBTSerializable element = (INBTSerializable)defaultElementCreator.get();
                element.deserializeNBT(elementTag);
                column[j] = element;
            }
            if (i == 0) {
                Class<?> columnClass = column.getClass();
                table = (INBTSerializable[][])Array.newInstance(columnClass, size);
            }
            table[i] = column;
        }
        return table;
    }

    public static <NBT extends NBTBase, T extends INBTSerializable<NBT>> NBTTagCompound writeTwoDimArrToNBT(T[][] objArr) {
        return NBTUtils.writeTwoDimArrToNBT(objArr, (T e) -> true);
    }

    public static <NBT extends NBTBase, T extends INBTSerializable<NBT>> NBTTagCompound writeTwoDimArrToNBT(T[][] objArr, Predicate<T> writeElementIf) {
        NBTTagCompound tableTag = new NBTTagCompound();
        for (int i = 0; i < objArr.length; ++i) {
            NBTTagCompound column = new NBTTagCompound();
            for (int j = 0; j < objArr[i].length; ++j) {
                if (!writeElementIf.test(objArr[i][j])) continue;
                NBTBase elementTag = objArr[i][j].serializeNBT();
                column.func_74782_a(Integer.toString(j), elementTag);
            }
            column.func_74768_a("size", objArr[i].length);
            tableTag.func_74782_a(Integer.toString(i), (NBTBase)column);
        }
        tableTag.func_74768_a("size", objArr.length);
        return tableTag;
    }

    public static <T> T[][] readTwoDimArrFromNBT(NBTTagCompound tableTag, Class<T> elementClass, Function<NBTTagCompound, T> deserializer) {
        int size = tableTag.func_74762_e("size");
        Object[][] table = null;
        for (int i = 0; i < size; ++i) {
            NBTTagCompound columnTag = tableTag.func_74775_l(Integer.toString(i));
            int columnSize = columnTag.func_74762_e("size");
            Object[] column = (Object[])Array.newInstance(elementClass, columnSize);
            for (int j = 0; j < columnSize; ++j) {
                if (!columnTag.func_74764_b(Integer.toString(j))) continue;
                NBTTagCompound elementTag = (NBTTagCompound)columnTag.func_74781_a(Integer.toString(j));
                column[j] = deserializer.apply(elementTag);
            }
            if (i == 0) {
                Class<?> columnClass = column.getClass();
                table = (Object[][])Array.newInstance(columnClass, size);
            }
            table[i] = column;
        }
        return table;
    }

    public static <T> NBTTagCompound writeTwoDimArrToNBT(T[][] objArr, Function<T, NBTTagCompound> serializer) {
        return NBTUtils.writeTwoDimArrToNBT(objArr, serializer, e -> true);
    }

    public static <T> NBTTagCompound writeTwoDimArrToNBT(T[][] objArr, Function<T, NBTTagCompound> serializer, Predicate<T> writeElementIf) {
        NBTTagCompound tableTag = new NBTTagCompound();
        for (int i = 0; i < objArr.length; ++i) {
            NBTTagCompound column = new NBTTagCompound();
            for (int j = 0; j < objArr[i].length; ++j) {
                if (!writeElementIf.test(objArr[i][j])) continue;
                NBTTagCompound elementTag = serializer.apply(objArr[i][j]);
                column.func_74782_a(Integer.toString(j), (NBTBase)elementTag);
            }
            column.func_74768_a("size", objArr[i].length);
            tableTag.func_74782_a(Integer.toString(i), (NBTBase)column);
        }
        tableTag.func_74768_a("size", objArr.length);
        return tableTag;
    }
}

