/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.timeconqueror.timecore.api.auxiliary.RandHelper;

public class BlockDungeonLamp
extends Block {
    public static final PropertyBool BROKEN = PropertyBool.func_177716_a((String)"broken");

    public BlockDungeonLamp() {
        super(Material.field_151592_s);
        this.func_149711_c(2.0f);
        this.func_149752_b(6.0f);
        this.func_149672_a(SoundType.field_185853_f);
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_176201_c(state) == 0 ? 15 : 0;
    }

    public int getHarvestLevel(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BROKEN) != false ? 1 : 4;
    }

    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"item.lootgames.dungeon_bricks.tooltip", (Object[])new Object[0]));
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }

    @Nullable
    public String getHarvestTool(IBlockState state) {
        return "pickaxe";
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int meta = this.func_176201_c(state);
        if (!((Boolean)state.func_177229_b((IProperty)BROKEN)).booleanValue()) {
            meta = (Integer)RandHelper.flipCoin((Object)0, (Object)1);
        }
        drops.add((Object)new ItemStack((Block)this, 1, meta));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BROKEN, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BROKEN) != false ? 1 : 0;
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 0));
        items.add((Object)new ItemStack((Block)this, 1, 1));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BROKEN});
    }
}

