/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import ru.timeconqueror.lootgames.LootGames;

public class CommandMain
extends CommandBase {
    public String func_71517_b() {
        return "lootgames";
    }

    public String func_71518_a(ICommandSender sender) {
        return "command.lootgames.main.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            throw new WrongUsageException("command.lootgames.main.usage", new Object[0]);
        }
        if (args[0].equals(Commands.PROFILE.getName()) && LootGames.logHelper.isInDev()) {
            this.printProfilingResults(sender);
        } else if (args[0].equals(Commands.HELP.getName())) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.lootgames.help.msg", new Object[0]));
            for (Commands value : Commands.values()) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(value.getUsage(), new Object[0]));
            }
        } else {
            throw new WrongUsageException("command.lootgames.main.usage", new Object[0]);
        }
    }

    private void printProfilingResults(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.lootgames." + (Object)((Object)Commands.PROFILE) + ".msg", new Object[0]));
        for (String identifier : LootGames.profiler.getIdentifiers()) {
            long averageTime = LootGames.profiler.getAverageTime(identifier);
            String result = averageTime == -1L ? "N/A" : String.format("%d ms", averageTime);
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("%s : %s", identifier, result)));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandMain.func_175762_a((String[])args, Commands.getCommands());
        }
        return Collections.emptyList();
    }

    private static enum Commands {
        PROFILE("profile"),
        HELP("help");

        private String name;
        private String usage;

        private Commands(String name) {
            this.name = name;
            this.usage = "command.lootgames." + name + ".usage";
        }

        public static ArrayList<String> getCommands() {
            ArrayList<String> commands = new ArrayList<String>();
            for (int i = 0; i < Commands.values().length; ++i) {
                if (Commands.values()[i] == PROFILE && !LootGames.logHelper.isInDev()) continue;
                commands.add(Commands.values()[i].name);
            }
            return commands;
        }

        public String getName() {
            return this.name;
        }

        public String getUsage() {
            return this.usage;
        }

        public String toString() {
            return this.name;
        }
    }
}

