/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.minigame.gameoflight;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.lootgames.achievement.AdvancementManager;
import ru.timeconqueror.lootgames.api.tileentity.TileEntityGameMaster;
import ru.timeconqueror.lootgames.api.util.DirectionOctagonal;
import ru.timeconqueror.lootgames.api.util.GameUtils;
import ru.timeconqueror.lootgames.block.BlockDungeonLamp;
import ru.timeconqueror.lootgames.block.BlockGOLSubordinate;
import ru.timeconqueror.lootgames.config.LGConfigGOL;
import ru.timeconqueror.lootgames.minigame.gameoflight.GameOfLight;
import ru.timeconqueror.lootgames.packets.NetworkHandler;
import ru.timeconqueror.lootgames.packets.SMessageGOLDrawStuff;
import ru.timeconqueror.lootgames.packets.SMessageGOLParticle;
import ru.timeconqueror.lootgames.registry.ModBlocks;
import ru.timeconqueror.lootgames.registry.ModSounds;
import ru.timeconqueror.lootgames.world.gen.DungeonGenerator;
import ru.timeconqueror.timecore.api.auxiliary.DirectionTetra;
import ru.timeconqueror.timecore.api.auxiliary.MessageUtils;

public class TileEntityGOLMaster
extends TileEntityGameMaster<GameOfLight>
implements ITickable {
    static final int MAX_TICKS_EXPANDING = 20;
    private static final int TICKS_PAUSE_BETWEEN_SYMBOLS = 12;
    private static final int TICKS_PAUSE_BETWEEN_STAGES = 25;
    static int ticksPerShowSymbols = 24;
    private int currentRound = -1;
    private int gameLevel = 1;
    private int ticks = 0;
    private int symbolIndex = 0;
    private boolean particleSent = false;
    private boolean pauseBeforeShowing = true;
    private List<ClickInfo> symbolsEnteredByPlayer;
    private int timeout = 0;
    private GameStage gameStage = GameStage.NOT_CONSTRUCTED;
    private List<Integer> symbolSequence;
    private List<Integer> maxLevelBeatList;
    private List<DrawInfo> stuffToDraw;
    private boolean feedbackPacketReceived;

    public TileEntityGOLMaster() {
        super(new GameOfLight());
    }

    @Override
    public void func_73660_a() {
        if (this.gameStage == GameStage.NOT_CONSTRUCTED) {
            return;
        }
        if (this.gameStage == GameStage.UNDER_EXPANDING) {
            if (this.ticks > 20) {
                if (!this.field_145850_b.field_72995_K) {
                    this.updateGameStage(GameStage.WAITING_FOR_START);
                }
            } else {
                ++this.ticks;
            }
        }
        if (this.gameStage == GameStage.SHOWING_SEQUENCE) {
            if (this.pauseBeforeShowing) {
                if (this.ticks > 25) {
                    this.ticks = 0;
                    this.pauseBeforeShowing = false;
                } else {
                    ++this.ticks;
                }
            } else if (this.field_145850_b.field_72995_K) {
                if (this.symbolIndex == this.symbolSequence.size() - 1 && this.ticks > ticksPerShowSymbols || this.ticks > ticksPerShowSymbols + 12) {
                    this.ticks = 0;
                    ++this.symbolIndex;
                    this.particleSent = false;
                } else {
                    ++this.ticks;
                }
                if (this.isShowingSymbols() && !this.particleSent) {
                    this.playFeedbackSound(this.getCurrentSymbolPosOffset());
                    this.spawnFeedbackParticles(EnumParticleTypes.SPELL, this.func_174877_v().func_177982_a(this.getCurrentSymbolPosOffset().getOffsetX(), 0, this.getCurrentSymbolPosOffset().getOffsetZ()));
                    this.particleSent = true;
                }
            } else if (this.feedbackPacketReceived) {
                this.feedbackPacketReceived = false;
                this.updateGameStage(GameStage.WAITING_FOR_PLAYER_SEQUENCE);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.gameStage == GameStage.WAITING_FOR_PLAYER_SEQUENCE) {
            if (this.timeout >= LGConfigGOL.timeout * 20) {
                this.updateGameStage(GameStage.WAITING_FOR_START);
            }
            ++this.timeout;
        }
        if (this.field_145850_b.field_72995_K && this.symbolsEnteredByPlayer != null) {
            this.symbolsEnteredByPlayer.removeIf(clickInfo -> System.currentTimeMillis() - ((ClickInfo)clickInfo).msClickedTime > 800L);
        }
        if (this.field_145850_b.field_72995_K && this.stuffToDraw != null && !this.stuffToDraw.isEmpty()) {
            this.stuffToDraw.removeIf(stuff -> System.currentTimeMillis() - ((DrawInfo)stuff).msClickedTime > 800L);
        }
    }

    private void generateSubordinates(EntityPlayer player) {
        this.field_145850_b.func_184133_a(null, this.field_174879_c, ModSounds.golStartGame, SoundCategory.BLOCKS, 0.75f, 1.0f);
        for (DirectionOctagonal value : DirectionOctagonal.values()) {
            IBlockState state = ModBlocks.GOL_SUBORDINATE.func_176223_P().func_177226_a(BlockGOLSubordinate.OFFSET, (Comparable)((Object)value));
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(value.getOffsetX(), 0, value.getOffsetZ()), state);
        }
        player.func_145747_a(MessageUtils.color((ITextComponent)new TextComponentTranslation("msg.lootgames.gol_master.start", new Object[0]), (TextFormatting)TextFormatting.AQUA));
        this.updateGameStage(GameStage.UNDER_EXPANDING);
    }

    public void onBlockClickedByPlayer(EntityPlayer player) {
        if (this.gameStage == GameStage.NOT_CONSTRUCTED) {
            this.generateSubordinates(player);
            return;
        }
        if (this.gameStage == GameStage.WAITING_FOR_START) {
            this.startGame(player);
            return;
        }
        if (this.gameStage == GameStage.WAITING_FOR_PLAYER_SEQUENCE) {
            player.func_145747_a(MessageUtils.color((ITextComponent)new TextComponentTranslation("msg.lootgames.gol_master.rules", new Object[0]), (TextFormatting)TextFormatting.GOLD));
            return;
        }
        player.func_145747_a(MessageUtils.color((ITextComponent)new TextComponentTranslation("msg.lootgames.gol_master.not_ready", new Object[0]), (TextFormatting)TextFormatting.AQUA));
    }

    public void onSubordinateClickedByPlayer(DirectionOctagonal subordinateOffset, EntityPlayer player) {
        if (this.gameStage == GameStage.WAITING_FOR_PLAYER_SEQUENCE) {
            if (this.field_145850_b.field_72995_K) {
                this.symbolsEnteredByPlayer.add(new ClickInfo(System.currentTimeMillis(), subordinateOffset));
                this.playFeedbackSound(subordinateOffset);
            } else {
                this.timeout = 0;
                this.checkPlayerReply(subordinateOffset, player);
            }
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            player.func_145747_a(MessageUtils.color((ITextComponent)new TextComponentTranslation("msg.lootgames.gol_master.not_ready", new Object[0]), (TextFormatting)TextFormatting.AQUA));
        }
    }

    private void checkPlayerReply(DirectionOctagonal subordinateOffset, EntityPlayer player) {
        if (DirectionOctagonal.byIndex(this.symbolSequence.get(this.symbolIndex)) == subordinateOffset) {
            if (this.symbolIndex == this.symbolSequence.size() - 1) {
                ++this.currentRound;
                if (this.currentRound >= LGConfigGOL.stage4.getMinRoundsRequiredToPass(this.field_145850_b.field_73011_w.getDimension())) {
                    this.gameLevel = 4;
                    this.onGameEnded(player);
                    return;
                }
                NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 15.0);
                if (this.currentRound >= LGConfigGOL.getStageByIndex(this.gameLevel).getMinRoundsRequiredToPass(this.field_145850_b.field_73011_w.getDimension())) {
                    NetworkHandler.INSTANCE.sendToAllAround((IMessage)new SMessageGOLParticle(this.func_174877_v(), EnumParticleTypes.VILLAGER_HAPPY.func_179348_c()), point);
                    player.func_145747_a(MessageUtils.color((ITextComponent)new TextComponentTranslation("msg.lootgames.stage_complete", new Object[0]), (TextFormatting)TextFormatting.GREEN));
                    this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187802_ec, SoundCategory.BLOCKS, 0.75f, 1.0f);
                    ++this.gameLevel;
                    this.onGameLevelChanged();
                }
                NetworkHandler.INSTANCE.sendToAllAround((IMessage)new SMessageGOLDrawStuff(this.func_174877_v(), EnumDrawStuff.SEQUENCE_ACCEPTED.ordinal()), point);
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), ModSounds.golSequenceComplete, SoundCategory.BLOCKS, 0.75f, 1.0f);
                if (LGConfigGOL.getStageByIndex((int)this.gameLevel).randomizeSequence) {
                    this.generateSequence(this.symbolSequence.size() + 1);
                } else {
                    this.addRandSymbolToSequence();
                }
                this.updateGameStage(GameStage.SHOWING_SEQUENCE);
            }
            ++this.symbolIndex;
        } else {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, ModSounds.golSequenceWrong, SoundCategory.BLOCKS, 0.75f, 1.0f);
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 15.0);
            NetworkHandler.INSTANCE.sendToAllAround((IMessage)new SMessageGOLDrawStuff(this.func_174877_v(), EnumDrawStuff.SEQUENCE_DENIED.ordinal()), point);
            player.func_145747_a(MessageUtils.color((ITextComponent)new TextComponentTranslation("msg.lootgames.gol_master.wrong_block", new Object[0]), (TextFormatting)TextFormatting.DARK_PURPLE));
            this.maxLevelBeatList.add(this.gameLevel - 1);
            this.onGameEnded(player);
        }
    }

    private void onGameLevelChanged() {
        ticksPerShowSymbols = LGConfigGOL.getStageByIndex((int)this.gameLevel).displayTime;
    }

    private void generateSequence(int size) {
        this.symbolSequence = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            this.addRandSymbolToSequence();
        }
    }

    private void addRandSymbolToSequence() {
        if (this.symbolSequence == null) {
            this.symbolSequence = new ArrayList<Integer>();
        }
        if (this.gameLevel >= LGConfigGOL.expandFieldAtStage) {
            this.symbolSequence.add(LootGames.RAND.nextInt(8));
        } else {
            this.symbolSequence.add(LootGames.RAND.nextInt(4) * 2);
        }
    }

    private void startGame(EntityPlayer player) {
        player.func_145747_a(MessageUtils.color((ITextComponent)new TextComponentTranslation("msg.lootgames.gol_master.rules", new Object[0]), (TextFormatting)TextFormatting.GOLD));
        this.currentRound = 0;
        this.gameLevel = 1;
        this.onGameLevelChanged();
        this.generateSequence(LGConfigGOL.startDigitAmount);
        this.updateGameStage(GameStage.SHOWING_SEQUENCE);
    }

    @SideOnly(value=Side.CLIENT)
    private void playFeedbackSound(DirectionOctagonal offset) {
        NoteBlockEvent.Note note = NoteBlockEvent.Note.G_SHARP;
        NoteBlockEvent.Octave octave = NoteBlockEvent.Octave.LOW;
        switch (offset) {
            case NORTH_WEST: {
                note = NoteBlockEvent.Note.G;
                break;
            }
            case NORTH: {
                note = NoteBlockEvent.Note.A;
                break;
            }
            case NORTH_EAST: {
                note = NoteBlockEvent.Note.B;
                break;
            }
            case EAST: {
                note = NoteBlockEvent.Note.C;
                break;
            }
            case SOUTH_EAST: {
                note = NoteBlockEvent.Note.D;
                break;
            }
            case SOUTH: {
                note = NoteBlockEvent.Note.E;
                break;
            }
            case SOUTH_WEST: {
                note = NoteBlockEvent.Note.F;
                break;
            }
            case WEST: {
                note = NoteBlockEvent.Note.G;
                octave = NoteBlockEvent.Octave.MID;
            }
        }
        this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187682_dG, SoundCategory.BLOCKS, 3.0f, this.getPitchForNote(note, octave), false);
    }

    private float getPitchForNote(NoteBlockEvent.Note note, NoteBlockEvent.Octave octave) {
        int noteID = note.ordinal() + octave.ordinal() * 12;
        return (float)Math.pow(2.0, (double)(noteID - 12) / 12.0);
    }

    public void onClientThingsDone() {
        this.feedbackPacketReceived = true;
    }

    @Override
    protected void readCommonNBT(NBTTagCompound compound) {
        super.readCommonNBT(compound);
        this.ticks = compound.func_74762_e("ticks");
        this.gameStage = GameStage.values()[compound.func_74762_e("game_stage")];
        this.onStageSetting(this.gameStage);
        this.timeout = compound.func_74762_e("timeout");
        this.currentRound = compound.func_74762_e("current_round");
        this.gameLevel = compound.func_74762_e("game_level");
        this.symbolSequence = Arrays.stream(compound.func_74759_k("symbol_sequence")).boxed().collect(Collectors.toList());
        this.maxLevelBeatList = Arrays.stream(compound.func_74759_k("max_level_beat")).boxed().collect(Collectors.toList());
    }

    @Override
    protected NBTTagCompound writeCommonNBT(NBTTagCompound compound) {
        compound = super.writeCommonNBT(compound);
        compound.func_74768_a("ticks", this.ticks);
        compound.func_74768_a("game_stage", this.gameStage.ordinal());
        compound.func_74768_a("game_level", this.gameLevel);
        compound.func_74768_a("current_round", this.currentRound);
        compound.func_74768_a("timeout", this.timeout);
        if (this.symbolSequence != null) {
            compound.func_74783_a("symbol_sequence", this.symbolSequence.stream().mapToInt(i -> i).toArray());
        }
        if (this.maxLevelBeatList != null) {
            compound.func_74783_a("max_level_beat", this.maxLevelBeatList.stream().mapToInt(i -> i).toArray());
        }
        return compound;
    }

    private void onGameEnded(EntityPlayer player) {
        if (this.isLastStagePassed() || this.maxLevelBeatList.size() == LGConfigGOL.maxAttempts + 1 && this.getBestLevelReached() > 0) {
            this.onGameWon(player);
        } else if (this.maxLevelBeatList.size() < LGConfigGOL.maxAttempts + 1) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), ModSounds.golStartGame, SoundCategory.BLOCKS, 0.75f, 1.0f);
            this.startGame(player);
        } else {
            this.onGameLost(player);
        }
    }

    private void onGameWon(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            AdvancementManager.WIN_GAME.trigger((EntityPlayerMP)player, "win");
        }
        if (this.maxLevelBeatList.size() == LGConfigGOL.maxAttempts + 1 && this.getBestLevelReached() > 0) {
            --this.gameLevel;
        }
        player.func_145747_a(MessageUtils.color((ITextComponent)new TextComponentTranslation("msg.lootgames.win", new Object[0]), (TextFormatting)TextFormatting.GREEN));
        this.field_145850_b.func_184133_a(null, this.func_174877_v(), ModSounds.golGameWin, SoundCategory.BLOCKS, 0.75f, 1.0f);
        int bestLevelReached = this.getBestLevelReached();
        if (bestLevelReached != -1) {
            player.func_145747_a(MessageUtils.color((ITextComponent)new TextComponentTranslation("msg.lootgames.gol_master.reward_level_reached", new Object[]{this.gameLevel, this.isLastStagePassed() ? 4 : bestLevelReached}), (TextFormatting)TextFormatting.GREEN));
        }
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                this.field_145850_b.func_175698_g(this.field_174879_c.func_177982_a(x, 0, z));
            }
        }
        this.destroyStructure();
        this.genLootChests(player);
    }

    private void onGameLost(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            AdvancementManager.WIN_GAME.trigger((EntityPlayerMP)player, "lose");
        }
        this.field_145850_b.func_184133_a(null, this.func_174877_v(), ModSounds.golGameLose, SoundCategory.BLOCKS, 0.75f, 1.0f);
        player.func_145747_a(MessageUtils.color((ITextComponent)new TextComponentTranslation("msg.lootgames.lose", new Object[0]), (TextFormatting)TextFormatting.DARK_PURPLE));
        this.destroyStructure();
        ArrayList<String> failEffects = new ArrayList<String>();
        if (LGConfigGOL.onFailExplode) {
            failEffects.add("explode");
        }
        if (LGConfigGOL.onFailLava) {
            failEffects.add("lava");
        }
        if (LGConfigGOL.onFailZombies) {
            failEffects.add("zombies");
        }
        if (failEffects.size() != 0) {
            this.executeFailEvent((String)failEffects.get(LootGames.RAND.nextInt(failEffects.size())));
        }
    }

    private void executeFailEvent(String pEffect) {
        block5: {
            block6: {
                block4: {
                    if (!pEffect.equalsIgnoreCase("explode")) break block4;
                    this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 6.0f, true);
                    break block5;
                }
                if (!pEffect.equalsIgnoreCase("lava")) break block6;
                for (int x = -5; x <= 5; ++x) {
                    for (int z = -5; z <= 5; ++z) {
                        for (int y = 1; y < 3; ++y) {
                            this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(x, y, z), Blocks.field_150353_l.func_176223_P());
                        }
                    }
                }
                break block5;
            }
            if (!pEffect.equalsIgnoreCase("zombies")) break block5;
            for (int i = 0; i < 10; ++i) {
                EntityZombie zombie = new EntityZombie(this.field_145850_b);
                zombie.func_70012_b((double)((float)this.field_174879_c.func_177958_n() + LootGames.RAND.nextFloat() * 2.0f), (double)(this.field_174879_c.func_177956_o() + 1), (double)((float)this.field_174879_c.func_177952_p() + LootGames.RAND.nextFloat() * 2.0f), MathHelper.func_76142_g((float)(LootGames.RAND.nextFloat() * 360.0f)), 0.0f);
                zombie.field_70759_as = zombie.field_70177_z;
                zombie.field_70761_aq = zombie.field_70177_z;
                this.field_145850_b.func_72838_d((Entity)zombie);
                zombie.func_70642_aH();
            }
        }
    }

    private void destroyStructure() {
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                if (x == 0 || z == 0) {
                    this.field_145850_b.func_175698_g(this.field_174879_c.func_177982_a(x, 0, z));
                    continue;
                }
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(x, 0, z), ModBlocks.DUNGEON_LAMP.func_176223_P().func_177226_a((IProperty)BlockDungeonLamp.BROKEN, (Comparable)Boolean.valueOf(false)));
            }
        }
        DungeonGenerator.resetUnbreakablePlayfield(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public void destroyGameBlocks() {
    }

    private boolean isLastStagePassed() {
        return this.gameLevel == 4 && this.currentRound >= LGConfigGOL.stage4.getMinRoundsRequiredToPass(this.field_145850_b.field_73011_w.getDimension());
    }

    private void genLootChests(EntityPlayer player) {
        int bestLevelReached = this.getBestLevelReached();
        if (bestLevelReached == -1 || this.isLastStagePassed()) {
            bestLevelReached = 4;
        }
        if (bestLevelReached < 1) {
            LootGames.logHelper.error("GenLootChests method was called in an appropriate time!");
            return;
        }
        this.spawnLootChest(DirectionTetra.NORTH, 1);
        if (bestLevelReached > 1) {
            this.spawnLootChest(DirectionTetra.EAST, 2);
        }
        if (bestLevelReached > 2) {
            if (player instanceof EntityPlayerMP) {
                AdvancementManager.WIN_GAME.trigger((EntityPlayerMP)player, "gol_level3");
            }
            this.spawnLootChest(DirectionTetra.SOUTH, 3);
        }
        if (bestLevelReached > 3) {
            if (player instanceof EntityPlayerMP) {
                AdvancementManager.WIN_GAME.trigger((EntityPlayerMP)player, "gol_level4");
            }
            this.spawnLootChest(DirectionTetra.WEST, 4);
        }
    }

    private void spawnLootChest(DirectionTetra direction, int gameLevel) {
        LGConfigGOL.Stage stage = LGConfigGOL.getStageByIndex(gameLevel);
        GameUtils.SpawnChestInfo chestInfo = new GameUtils.SpawnChestInfo(GameOfLight.class, stage.getLootTableRL(this.field_145850_b.field_73011_w.getDimension()), stage.minItems, stage.maxItems);
        GameUtils.spawnLootChest(this.func_145831_w(), this.func_174877_v(), direction, chestInfo);
    }

    private void updateGameStage(GameStage gameStage) {
        this.gameStage = gameStage;
        this.onStageSetting(gameStage);
        this.setBlockToUpdateAndSave();
    }

    private int getBestLevelReached() {
        int i = -1;
        for (Integer attempt : this.maxLevelBeatList) {
            if (attempt <= i) continue;
            i = attempt;
        }
        return i;
    }

    private void spawnFeedbackParticles(EnumParticleTypes particle, BlockPos pos) {
        for (int i = 0; i < 20; ++i) {
            this.field_145850_b.func_175688_a(particle, (double)((float)pos.func_177958_n() + LootGames.RAND.nextFloat()), (double)((float)pos.func_177956_o() + 0.5f + LootGames.RAND.nextFloat()), (double)((float)pos.func_177952_p() + LootGames.RAND.nextFloat()), LootGames.RAND.nextGaussian() * 0.02, (0.02 + LootGames.RAND.nextGaussian()) * 0.02, LootGames.RAND.nextGaussian() * 0.02, new int[0]);
        }
    }

    @NotNull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177982_a(-2, 0, -2), this.func_174877_v().func_177982_a(2, 1, 2));
    }

    GameStage getGameStage() {
        return this.gameStage;
    }

    boolean isShowingSymbols() {
        return this.symbolIndex < this.symbolSequence.size();
    }

    DirectionOctagonal getCurrentSymbolPosOffset() {
        return DirectionOctagonal.byIndex(this.symbolSequence.get(this.symbolIndex));
    }

    int getTicks() {
        return this.ticks;
    }

    List<ClickInfo> getSymbolsEnteredByPlayer() {
        return this.symbolsEnteredByPlayer;
    }

    @SideOnly(value=Side.CLIENT)
    List<DrawInfo> getStuffToDraw() {
        return this.stuffToDraw;
    }

    @SideOnly(value=Side.CLIENT)
    public void addStuffToDraw(DrawInfo stuff) {
        if (this.stuffToDraw == null) {
            this.stuffToDraw = new ArrayList<DrawInfo>();
        }
        this.stuffToDraw.add(stuff);
    }

    boolean isFeedbackPacketReceived() {
        return this.feedbackPacketReceived;
    }

    boolean isOnPause() {
        return this.pauseBeforeShowing;
    }

    private void onStageSetting(GameStage stage) {
        this.ticks = 0;
        if (stage == GameStage.SHOWING_SEQUENCE) {
            this.feedbackPacketReceived = false;
            this.symbolIndex = 0;
            this.particleSent = false;
            this.pauseBeforeShowing = true;
        }
        if (stage == GameStage.WAITING_FOR_PLAYER_SEQUENCE) {
            this.timeout = 0;
            this.symbolIndex = 0;
            if (this.maxLevelBeatList == null) {
                this.maxLevelBeatList = new ArrayList<Integer>();
            }
            if (this.func_145830_o() && this.field_145850_b.field_72995_K) {
                this.symbolsEnteredByPlayer = new LinkedList<ClickInfo>();
            }
        }
    }

    public static class ClickInfo {
        private long msClickedTime;
        private DirectionOctagonal offset;

        private ClickInfo(long msClickedTime, DirectionOctagonal offset) {
            this.msClickedTime = msClickedTime;
            this.offset = offset;
        }

        DirectionOctagonal getOffset() {
            return this.offset;
        }
    }

    public static class DrawInfo {
        private long msClickedTime;
        private EnumDrawStuff stuff;

        public DrawInfo(long msClickedTime, EnumDrawStuff stuff) {
            this.msClickedTime = msClickedTime;
            this.stuff = stuff;
        }

        EnumDrawStuff getStuff() {
            return this.stuff;
        }
    }

    public static enum EnumDrawStuff {
        SEQUENCE_ACCEPTED,
        SEQUENCE_DENIED,
        SHOWING_SEQUENCE;

    }

    public static enum GameStage {
        NOT_CONSTRUCTED,
        UNDER_EXPANDING,
        WAITING_FOR_START,
        SHOWING_SEQUENCE,
        WAITING_FOR_PLAYER_SEQUENCE;

    }
}

