/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.minigame.minesweeper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.timeconqueror.lootgames.api.util.NBTUtils;
import ru.timeconqueror.lootgames.api.util.Pos2i;

public class MSBoard {
    private MSField[][] board;
    private int size;
    private int bombCount;
    @SideOnly(value=Side.CLIENT)
    int cFlaggedFields;

    public MSBoard(int size, int bombCount) {
        this.size = size;
        this.bombCount = bombCount;
    }

    @SideOnly(value=Side.CLIENT)
    void updateFlaggedFields_c() {
        this.cFlaggedFields = 0;
        MSField[][] mSFieldArray = this.board;
        int n = mSFieldArray.length;
        for (int i = 0; i < n; ++i) {
            MSField[] msFields;
            for (MSField msField : msFields = mSFieldArray[i]) {
                if (msField.getMark() != 1) continue;
                ++this.cFlaggedFields;
            }
        }
    }

    public boolean isGenerated() {
        return this.board != null;
    }

    void reveal(Pos2i pos) {
        this.getField(pos).reveal();
    }

    void reveal(int x, int y) {
        this.getField(x, y).reveal();
    }

    public boolean isHidden(Pos2i pos) {
        return this.getField(pos).isHidden();
    }

    public boolean isHidden(int x, int y) {
        return this.getField(x, y).isHidden();
    }

    @MSField.Type
    public int getType(Pos2i pos) {
        return this.getField(pos).getType();
    }

    @MSField.Type
    public int getType(int x, int y) {
        return this.getField(x, y).getType();
    }

    void swapMark(Pos2i pos) {
        this.getField(pos).swapMark();
    }

    @MSField.Mark
    public int getMark(Pos2i pos) {
        return this.getField(pos).getMark();
    }

    @MSField.Mark
    public int getMark(int x, int y) {
        return this.getField(x, y).getMark();
    }

    void resetBoard() {
        this.resetBoard(this.size, this.bombCount);
    }

    void resetBoard(int newBoardSize, int newBombCount) {
        this.size = newBoardSize;
        this.bombCount = newBombCount;
        this.board = null;
    }

    boolean isBomb(int x, int y) {
        return this.getType(x, y) == -1;
    }

    boolean isBomb(Pos2i pos) {
        return this.getType(pos) == -1;
    }

    public boolean hasFieldOn(Pos2i pos) {
        return pos.getX() >= 0 && pos.getY() >= 0 && pos.getX() < this.size && pos.getY() < this.size;
    }

    boolean checkWin() {
        boolean winState = true;
        MSField[][] mSFieldArray = this.board;
        int n = mSFieldArray.length;
        block0: for (int i = 0; i < n; ++i) {
            MSField[] msFields;
            for (MSField msField : msFields = mSFieldArray[i]) {
                if (msField.type == -1) {
                    if (msField.isHidden && msField.getMark() == 1) continue;
                    winState = false;
                    break block0;
                }
                if (!msField.isHidden) continue;
                winState = false;
                break block0;
            }
        }
        return winState;
    }

    private MSField getField(Pos2i pos) {
        return this.board[pos.getX()][pos.getY()];
    }

    private MSField getField(int x, int y) {
        return this.board[x][y];
    }

    public void generate(Pos2i startFieldPos) {
        int i;
        if (this.convertToFieldIndex(startFieldPos) > this.size * this.size - 1) {
            throw new IllegalArgumentException(String.format("Start Pos must be strictly less than Board size. Current values: start pos = %1$s, boardSize = %2$d", startFieldPos, this.size));
        }
        this.board = new MSField[this.size][this.size];
        int square = this.size * this.size;
        ArrayList<Integer> fields = new ArrayList<Integer>(square);
        for (i = 0; i < square; ++i) {
            if (i == this.convertToFieldIndex(startFieldPos)) continue;
            fields.add(i);
        }
        Collections.shuffle(fields);
        for (i = 0; i < this.board.length; ++i) {
            for (int j = 0; j < this.board[i].length; ++j) {
                this.board[i][j] = new MSField(-2, true, 0);
            }
        }
        for (Integer integer : fields.subList(0, this.bombCount)) {
            this.board[integer % this.size][integer / this.size].type = -1;
        }
        for (int i2 = 0; i2 < this.board.length; ++i2) {
            for (int j = 0; j < this.board[i2].length; ++j) {
                if (this.isBomb(i2, j)) continue;
                this.board[i2][j].type = this.getConnectedBombCount(i2, j);
            }
        }
        this.getField(startFieldPos).reveal();
    }

    private Pos2i convertToPos(int fieldIndex) {
        return new Pos2i(fieldIndex % this.size, fieldIndex / this.size);
    }

    private int convertToFieldIndex(Pos2i pos) {
        return pos.getY() * this.size + pos.getX();
    }

    private int getConnectedBombCount(int x, int y) {
        int bombCount = 0;
        for (int i = -1; i <= 1; ++i) {
            int xCoord = x + i;
            if (xCoord < 0 || xCoord >= this.size()) continue;
            for (int j = -1; j <= 1; ++j) {
                int yCoord = y + j;
                if (yCoord < 0 || yCoord >= this.size() || !this.isBomb(xCoord, yCoord)) continue;
                ++bombCount;
            }
        }
        return bombCount;
    }

    public void forEach(Consumer<Pos2i> func) {
        for (int x = 0; x < this.board.length; ++x) {
            for (int y = 0; y < this.board[x].length; ++y) {
                func.accept(new Pos2i(x, y));
            }
        }
    }

    public void forEach(BiConsumer<Integer, Integer> func) {
        for (int x = 0; x < this.board.length; ++x) {
            for (int y = 0; y < this.board[x].length; ++y) {
                func.accept(x, y);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    void setField(Pos2i pos, int type, boolean hidden, int mark) {
        MSField oldField = this.board[pos.getX()][pos.getY()];
        int oldMark = oldField.mark;
        if (!hidden) {
            mark = 0;
        }
        this.board[pos.getX()][pos.getY()] = new MSField(type, hidden, mark);
        if (oldMark == 1 && mark != 1) {
            --this.cFlaggedFields;
        } else if (oldMark != 1 && mark == 1) {
            ++this.cFlaggedFields;
        }
    }

    void setBoard(MSField[][] board) {
        this.board = board;
    }

    public int size() {
        return this.size;
    }

    public int getBombCount() {
        return this.bombCount;
    }

    void setBombCount(int bombCount) {
        this.bombCount = bombCount;
    }

    @SideOnly(value=Side.CLIENT)
    public int getFlaggedField_c() {
        return this.cFlaggedFields;
    }

    void setSize(int size) {
        this.size = size;
    }

    NBTTagCompound writeNBTForSaving() {
        return NBTUtils.writeTwoDimArrToNBT((INBTSerializable[][])this.board);
    }

    NBTTagCompound writeNBTForClient() {
        return NBTUtils.writeTwoDimArrToNBT(this.board, field -> {
            NBTTagCompound c = new NBTTagCompound();
            c.func_74757_a("hidden", field.isHidden());
            c.func_74768_a("mark", field.getMark());
            if (!field.isHidden()) {
                c.func_74768_a("type", field.getType());
            }
            return c;
        });
    }

    public static class MSField
    implements INBTSerializable<NBTTagCompound> {
        public static final int BOMB = -1;
        public static final int EMPTY = 0;
        public static final int NO_MARK = 0;
        public static final int FLAG = 1;
        public static final int QUESTION_MARK = 2;
        private int type;
        private int mark;
        private boolean isHidden;

        MSField(int type, boolean isHidden, int mark) {
            this.type = type;
            this.isHidden = isHidden;
            this.mark = mark;
        }

        private void swapMark() {
            this.mark = this.mark == 2 ? 0 : ++this.mark;
        }

        private void resetMark() {
            this.mark = 0;
        }

        private void reveal() {
            this.isHidden = false;
            this.resetMark();
        }

        @Type
        public int getType() {
            return this.type;
        }

        @Mark
        public int getMark() {
            return this.mark;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound field = new NBTTagCompound();
            field.func_74768_a("mark", this.mark);
            field.func_74757_a("hidden", this.isHidden);
            field.func_74768_a("type", this.type);
            return field;
        }

        public boolean isHidden() {
            return this.isHidden;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.isHidden = nbt.func_74767_n("hidden");
            this.mark = nbt.func_74762_e("mark");
            this.type = nbt.func_74762_e("type");
        }

        public String toString() {
            return "Field{type: " + this.type + ", hidden: " + this.isHidden + ", mark: " + this.mark + "}";
        }

        public static @interface Mark {
        }

        public static @interface Type {
        }
    }
}

