/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.minigame.minesweeper.client;

import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.timeconqueror.lootgames.minigame.minesweeper.GameMineSweeper;
import ru.timeconqueror.lootgames.minigame.minesweeper.tileentity.TileEntityMSMaster;
import ru.timeconqueror.timecore.api.auxiliary.RenderHelper;
import ru.timeconqueror.timecore.api.auxiliary.client.ClientUtils;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class MSOverlayHandler {
    private static final ResourceLocation OVERLAY = new ResourceLocation("lootgames", "textures/gui/minesweeper/ms_overlay.png");
    private static final ArrayList<TileEntityMSMaster> MS_MASTERS = new ArrayList(1);
    private static final RenderHelper.TexturedRect firstSlotStart = new RenderHelper.TexturedRect(4.5f, 24.0f, 15.0f, 0.0f, 3.0f, 16.0f);
    private static final RenderHelper.TexturedRect firstSlotRepeat = new RenderHelper.TexturedRect(39.0f, 24.0f, 18.0f, 0.0f, 26.0f, 16.0f);
    private static final RenderHelper.TexturedRect firstSlotEnd = new RenderHelper.TexturedRect(6.0f, 24.0f, 44.0f, 0.0f, 4.0f, 16.0f);
    private static final RenderHelper.TexturedRect extraSlotStart = new RenderHelper.TexturedRect(4.5f, 15.0f, 15.0f, 16.0f, 3.0f, 10.0f);
    private static final RenderHelper.TexturedRect extraSlotRepeat = new RenderHelper.TexturedRect(39.0f, 15.0f, 18.0f, 16.0f, 26.0f, 10.0f);
    private static final RenderHelper.TexturedRect extraSlotEnd = new RenderHelper.TexturedRect(6.0f, 15.0f, 44.0f, 16.0f, 4.0f, 10.0f);

    @SubscribeEvent
    public static void renderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            MSOverlayHandler.renderNearbyGameBombs();
            MS_MASTERS.clear();
        }
    }

    private static void renderNearbyGameBombs() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179141_d();
        MS_MASTERS.removeIf(arg_0 -> MSOverlayHandler.lambda$renderNearbyGameBombs$0((EntityPlayer)player, arg_0));
        if (MS_MASTERS.isEmpty()) {
            return;
        }
        boolean extendedInfo = false;
        if (MS_MASTERS.size() > 1) {
            extendedInfo = true;
        }
        float maxRectWidth = 0.0f;
        for (TileEntityMSMaster msMaster : MS_MASTERS) {
            GameMineSweeper game = (GameMineSweeper)msMaster.getGame();
            String toDisplay = MSOverlayHandler.getBombDisplayString(game, extendedInfo);
            maxRectWidth = Math.max(maxRectWidth, (float)fontRenderer.func_78256_a(toDisplay) + 11.0f);
        }
        float startY = 20.0f;
        for (int i = 0; i < MS_MASTERS.size(); ++i) {
            TileEntityMSMaster msMaster = MS_MASTERS.get(i);
            GameMineSweeper game = (GameMineSweeper)msMaster.getGame();
            ClientUtils.bindTexture((ResourceLocation)OVERLAY);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            Color color = game.getStage() == GameMineSweeper.Stage.DETONATING || game.getStage() == GameMineSweeper.Stage.EXPLODING ? Color.RED : Color.WHITE;
            String toDisplay = MSOverlayHandler.getBombDisplayString(game, extendedInfo);
            if (i == 0) {
                RenderHelper.drawTexturedRect((double)5.0, (double)5.0, (double)22.5, (double)24.0, (double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)48.0);
                RenderHelper.drawWidthExpandableTexturedRect((float)27.5f, (float)5.0f, (float)maxRectWidth, (float)0.0f, (RenderHelper.TexturedRect)firstSlotStart, (RenderHelper.TexturedRect)firstSlotRepeat, (RenderHelper.TexturedRect)firstSlotEnd, (float)48.0f);
                RenderHelper.drawYCenteredStringWithShadow((FontRenderer)fontRenderer, (String)toDisplay, (float)32.6f, (float)17.5f, (int)color.getRGB());
                continue;
            }
            RenderHelper.drawWidthExpandableTexturedRect((float)27.5f, (float)startY, (float)maxRectWidth, (float)0.0f, (RenderHelper.TexturedRect)extraSlotStart, (RenderHelper.TexturedRect)extraSlotRepeat, (RenderHelper.TexturedRect)extraSlotEnd, (float)48.0f);
            RenderHelper.drawYCenteredStringWithShadow((FontRenderer)fontRenderer, (String)toDisplay, (float)32.6f, (float)(startY + 8.0f), (int)color.getRGB());
            startY += 10.5f;
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
    }

    private static String getBombDisplayString(GameMineSweeper game, boolean extended) {
        int bombDisplay = game.getStage() == GameMineSweeper.Stage.DETONATING || game.getStage() == GameMineSweeper.Stage.EXPLODING ? game.getBoard().getBombCount() : game.getBoard().getBombCount() - game.getBoard().getFlaggedField_c();
        BlockPos gamePos = game.getCentralGamePos();
        return extended ? "x" + bombDisplay + " {" + gamePos.func_177958_n() + ", " + gamePos.func_177956_o() + ", " + gamePos.func_177952_p() + "}" : "x" + bombDisplay;
    }

    public static void addSupportedMaster(TileEntityMSMaster master) {
        if (!Minecraft.func_71410_x().field_71474_y.field_74319_N || Minecraft.func_71410_x().field_71462_r != null) {
            MS_MASTERS.add(master);
        }
    }

    private static /* synthetic */ boolean lambda$renderNearbyGameBombs$0(EntityPlayer player, TileEntityMSMaster tileEntityMSMaster) {
        GameMineSweeper game = (GameMineSweeper)tileEntityMSMaster.getGame();
        BlockPos gamePos = game.getCentralGamePos();
        return player.func_174818_b(gamePos) > (double)(game.getDefaultBroadcastDistance() * game.getDefaultBroadcastDistance());
    }
}

