/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.minigame.minesweeper.client;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import ru.timeconqueror.lootgames.minigame.minesweeper.GameMineSweeper;
import ru.timeconqueror.lootgames.minigame.minesweeper.client.MSOverlayHandler;
import ru.timeconqueror.lootgames.minigame.minesweeper.tileentity.TileEntityMSMaster;
import ru.timeconqueror.timecore.api.auxiliary.RenderHelper;

@SideOnly(value=Side.CLIENT)
public class TESRMSMaster
extends TileEntitySpecialRenderer<TileEntityMSMaster> {
    private static final ResourceLocation MS_BOARD = new ResourceLocation("lootgames", "textures/blocks/minesweeper/ms_board.png");

    public void render(TileEntityMSMaster te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        this.func_147499_a(MS_BOARD);
        GameMineSweeper game = (GameMineSweeper)te.getGame();
        int boardSize = game.getBoardSize();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y + 1.0), (double)z);
        GlStateManager.func_179140_f();
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        if (!game.cIsGenerated) {
            for (int xL = 0; xL < boardSize; ++xL) {
                for (int zL = 0; zL < boardSize; ++zL) {
                    RenderHelper.drawTexturedRectP((double)xL, (double)zL, (double)1.0, (double)1.0, (double)-0.005f, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.25);
                }
            }
        } else {
            for (int xL = 0; xL < boardSize; ++xL) {
                for (int zL = 0; zL < boardSize; ++zL) {
                    int textureY;
                    int textureX;
                    boolean isHidden = game.getBoard().isHidden(xL, zL);
                    int type = game.getBoard().getType(xL, zL);
                    if (!isHidden && type == -1) {
                        int max = game.detonationTimeInTicks;
                        int ticks = game.getTicks();
                        int times = 9;
                        float period = (float)max / (float)times;
                        float extendedPeriod = period * (float)(times + 1) / (float)times;
                        double alphaFactor = game.getStage() == GameMineSweeper.Stage.EXPLODING ? 1.0 : Math.abs(Math.sin(Math.toRadians((float)ticks / extendedPeriod * 180.0f)));
                        RenderHelper.drawTexturedRectP((double)xL, (double)zL, (double)1.0, (double)1.0, (double)-0.005f, (double)1.0, (double)0.0, (double)1.0, (double)1.0, (double)0.25);
                        GlStateManager.func_179147_l();
                        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                        GlStateManager.func_179141_d();
                        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)alphaFactor);
                        RenderHelper.drawTexturedRectP((double)xL, (double)zL, (double)1.0, (double)1.0, (double)-0.005f, (double)1.0, (double)3.0, (double)1.0, (double)1.0, (double)0.25);
                        GlStateManager.func_179118_c();
                        GlStateManager.func_179084_k();
                        continue;
                    }
                    int mark = game.getBoard().getMark(xL, zL);
                    if (isHidden) {
                        if (mark == 0) {
                            textureX = 0;
                            textureY = 0;
                        } else if (mark == 1) {
                            textureX = 3;
                            textureY = 0;
                        } else {
                            textureX = 0;
                            textureY = 3;
                        }
                    } else if (type > 0) {
                        textureX = type % 4 == 0 ? 3 : type % 4 - 1;
                        textureY = type <= 4 ? 1 : 2;
                    } else {
                        textureX = 2;
                        textureY = 0;
                    }
                    RenderHelper.drawTexturedRectP((double)xL, (double)zL, (double)1.0, (double)1.0, (double)-0.005f, (double)textureX, (double)textureY, (double)1.0, (double)1.0, (double)0.25);
                }
            }
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        MSOverlayHandler.addSupportedMaster(te);
    }

    public boolean isGlobalRenderer(TileEntityMSMaster te) {
        return true;
    }
}

