/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.minigame.minesweeper.task;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.ApiStatus;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.lootgames.api.task.ITask;
import ru.timeconqueror.lootgames.api.util.Pos2i;
import ru.timeconqueror.lootgames.minigame.minesweeper.GameMineSweeper;
import ru.timeconqueror.lootgames.minigame.minesweeper.tileentity.TileEntityMSMaster;

public class TaskMSCreateExplosion
implements ITask {
    private Pos2i relativePos;
    private BlockPos masterPos;
    private float strength;
    private boolean damagesTerrain;

    @ApiStatus.Internal
    public TaskMSCreateExplosion() {
    }

    public TaskMSCreateExplosion(BlockPos masterPos, Pos2i relativePos, float strength, boolean damagesTerrain) {
        this.relativePos = relativePos;
        this.masterPos = masterPos;
        this.strength = strength;
        this.damagesTerrain = damagesTerrain;
    }

    @Override
    public void run(World world) {
        TileEntity te = world.func_175625_s(this.masterPos);
        if (te instanceof TileEntityMSMaster) {
            GameMineSweeper ms = (GameMineSweeper)((TileEntityMSMaster)te).getGame();
            BlockPos relPos = ms.convertToBlockPos(this.relativePos);
            world.func_72876_a(null, (double)relPos.func_177958_n(), (double)relPos.func_177956_o(), (double)relPos.func_177952_p(), this.strength, this.damagesTerrain);
            NBTTagCompound c = new NBTTagCompound();
            c.func_74768_a("x", this.relativePos.getX());
            c.func_74768_a("y", this.relativePos.getY());
            c.func_74768_a("type", 0);
            c.func_74757_a("hidden", false);
            c.func_74768_a("mark", 0);
            ms.sendUpdatePacket("field_changed", c);
        } else {
            LootGames.logHelper.error("Can't find MineSweeper Master at %s while running TaskMSCreateExplosion...", new Object[]{this.masterPos});
            world.func_72876_a(null, (double)(this.masterPos.func_177958_n() + this.relativePos.getX()), (double)this.masterPos.func_177956_o() + 1.5, (double)(this.masterPos.func_177952_p() + this.relativePos.getY()), this.strength, this.damagesTerrain);
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound t = new NBTTagCompound();
        t.func_74780_a("x", (double)this.masterPos.func_177958_n());
        t.func_74780_a("y", (double)this.masterPos.func_177956_o());
        t.func_74780_a("z", (double)this.masterPos.func_177952_p());
        t.func_74768_a("rel_x", this.relativePos.getX());
        t.func_74768_a("rel_y", this.relativePos.getY());
        t.func_74776_a("strength", this.strength);
        t.func_74757_a("damagesTerrain", this.damagesTerrain);
        return t;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.relativePos = new Pos2i(nbt.func_74762_e("rel_x"), nbt.func_74762_e("rel_y"));
        this.masterPos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        this.strength = nbt.func_74760_g("strength");
        this.damagesTerrain = nbt.func_74767_n("damagesTerrain");
    }
}

